/****************************************************************************
*
* Copyright © 2015-2021 STMicroelectronics - All Rights Reserved
*
* This software is licensed under SLA0098 terms that can be found in the
* DM00779817_1_0.pdf file in the licenses directory of this software product.
* 
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED, 
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
*****************************************************************************/

/* Inclusion of the main header files of all the imported components in the
   order specified in the application wizard. The file is generated
   automatically.*/
#include "components.h"
#include "can_lld.h"
#include "can_lld_cfg.h"
#include "pit_lld.h"
#include "pit_lld_cfg.h"

/*
 * Application entry point.
 */

#define YURA_CAN_DTG_MSG_ID         0x18FF10EE
#define YURA_CAN_AXI_MSG_ID         0x18FFE7EE
#define YURA_CAN_TD_MSG_ID          0x18FEE6EE
#define YURA_CAN_VDHR_MSG_ID        0x18FEC1EE
#define YURA_CAN_VP_MSG_ID          0x18FEF3EE
#define YURA_CAN_DM1_DTG_MSG_ID     0x18FECAEE


#define TIM_PIT_CHAL_NUM    1

#define DTG_MSG_PERI        5       // 5x 10 = 50msec
#define AXI_MSG_PERI        10       // 5x 10 = 50msec
#define TD_MSG_PERI         100       // 5x 10 = 50msec
#define VDHR_MSG_PERI       100       // 5x 10 = 50msec
#define VP_MSG_PERI         100       // 5x 10 = 50msec
#define DM1_DTG_MSG_PERI    100       // 5x 10 = 50msec


CANTxFrame can_txf;

unsigned char f_dtg_can_msg_send=0;
unsigned char f_axi_can_msg_send=0;
unsigned char f_td_can_msg_send=0;
unsigned char f_VDHR_can_msg_send=0;
unsigned char f_vp_can_msg_send=0;
unsigned char f_dm1_dtg_can_msg_send=0;


unsigned int DTG_MSG_Counter=0;
unsigned int AXI_MSG_Counter=0;
unsigned int TD_MSG_Counter=0;
unsigned int VDHR_MSG_Counter=0;
unsigned int VP_MSG_Counter=0;
unsigned int DM1_DTG_MSG_Counter=0;


void mcanconf_cb_can_tx_error(CANDriver *canp, uint32_t psr)
{

    can_txf.data32[0] = 0x00000000;
    can_txf.data32[1] = 0x00000000;
}



void cb_pit0_ch1(void)          // 10msec Timer;
{
    static unsigned int dtg_msg_counter=0;
    static unsigned int axi_msg_counter=0;
    static unsigned int td_msg_counter=0;
    static unsigned int vdhr_msg_counter=0;
    static unsigned int vp_msg_counter=0;
    static unsigned int dm1_dtg_msg_counter=0;

    //DTG MSG Counter
    dtg_msg_counter++;
    if(dtg_msg_counter >=DTG_MSG_PERI)
    {
        dtg_msg_counter=0;
        f_dtg_can_msg_send=1;
    }

    //AXI MSG Counter
    axi_msg_counter++;
    if(axi_msg_counter >=AXI_MSG_PERI)
    {
        axi_msg_counter=0;
        f_axi_can_msg_send=1;
    }

    //TD MSG Counter
    td_msg_counter++;
    if(td_msg_counter >=TD_MSG_PERI )
    {
        td_msg_counter=0;
        f_td_can_msg_send=1;
    }

    //VDHR MSG Counter
    vdhr_msg_counter++;
    if(vdhr_msg_counter >=VDHR_MSG_PERI)
    {
        vdhr_msg_counter=0;
        f_VDHR_can_msg_send=1;
    }

    //DTG MSG Counter
    vp_msg_counter++;
    if(vp_msg_counter >=VP_MSG_PERI)
    {
        vp_msg_counter=0;
        f_vp_can_msg_send=1;
    }

    //DTG MSG Counter
    dm1_dtg_msg_counter++;
    if(dm1_dtg_msg_counter >=DM1_DTG_MSG_PERI)
    {
        dm1_dtg_msg_counter=0;
        f_dm1_dtg_can_msg_send=1;
    }
}


int main(void) {

  /* Initialization of all the imported components in the order specified in
     the application wizard. The function is generated automatically.*/
    componentsInit();

    pit_lld_init();
    pit_lld_start(&PITD1, &pit0_config[0]);
    

    can_lld_start(&CAND4, &can_config_mcanconf); /*CANSUB_0 MCAN_2*/
    can_txf.OPERATION=CAN_OP_NORMAL;
    can_txf.TYPE = CAN_ID_XTD;
	can_txf.ID = YURA_CAN_DTG_MSG_ID;
	can_txf.DLC = 8U;
    can_txf.data32[0] = 0x00000000;
    can_txf.data32[1] = 0x00000000;

  /* Uncomment the below routine to Enable Interrupts. */
   irqIsrEnable();  

    pal_lld_setpad(PORT_CAN_EN, CAN_EN);
    pal_lld_setpad(PORT_CAN_STB, CAN_STB);



    osalThreadDelaySeconds(300);

    
    pit_lld_channel_start(&PITD1, TIM_PIT_CHAL_NUM);
  
  /* Application main loop.*/
  for ( ; ; ) {

    if(f_dtg_can_msg_send)
    {
        f_dtg_can_msg_send=0;
        can_txf.ID = YURA_CAN_DTG_MSG_ID;
        DTG_MSG_Counter++;
        can_txf.data32[0] = DTG_MSG_Counter;
        can_lld_transmit(&CAND4, CAN_ANY_TXBUFFER, &can_txf);
        
    }
    
    if(f_axi_can_msg_send)
    {
        f_axi_can_msg_send=0;
        can_txf.ID = YURA_CAN_AXI_MSG_ID;
        AXI_MSG_Counter++;
        can_txf.data32[0] = AXI_MSG_Counter;
        can_lld_transmit(&CAND4, CAN_ANY_TXBUFFER, &can_txf);
        
    }

    if(f_td_can_msg_send)
    {
        f_td_can_msg_send=0;
        can_txf.ID = YURA_CAN_TD_MSG_ID;
        TD_MSG_Counter++;
        can_txf.data32[0] = TD_MSG_Counter;
        can_lld_transmit(&CAND4, CAN_ANY_TXBUFFER, &can_txf);
    }

    if(f_VDHR_can_msg_send)
    {
        f_VDHR_can_msg_send=0;
        can_txf.ID = YURA_CAN_VDHR_MSG_ID;
        VDHR_MSG_Counter++;
        can_txf.data32[0] = VDHR_MSG_Counter;
        can_lld_transmit(&CAND4, CAN_ANY_TXBUFFER, &can_txf);
        
    }

    if(f_vp_can_msg_send)
    {
        f_vp_can_msg_send=0;
        can_txf.ID = YURA_CAN_VP_MSG_ID;
        VP_MSG_Counter++;
        can_txf.data32[0] = VP_MSG_Counter;
        can_lld_transmit(&CAND4, CAN_ANY_TXBUFFER, &can_txf);
        
    }

    if(f_dm1_dtg_can_msg_send)
    {
        f_dm1_dtg_can_msg_send=0;
        can_txf.ID = YURA_CAN_DM1_DTG_MSG_ID;
        DM1_DTG_MSG_Counter++;
        can_txf.data32[0] = DM1_DTG_MSG_Counter;
        can_lld_transmit(&CAND4, CAN_ANY_TXBUFFER, &can_txf);
    }


  }
}
