/****************************************************************************
*
* Copyright © 2019 STMicroelectronics - All Rights Reserved
*
* This software is licensed under SLA0098 terms that can be found in the
* DM00779817_1_0.pdf file in the licenses directory of this software product.
* 
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED, 
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
*****************************************************************************/

/**
 * @file    platform.h
 * @brief   platform file.
 */

#ifndef _PLATFORM_H_
#define _PLATFORM_H_

#include "core.h"
#include "toolchain.h"
#include "intc.h"
#if !defined(_FROM_ASM_)
#include "typedefs.h"
#include "spr.h"
#include "spc58xh_registry.h"
#include "spc58xhxx.h"
#include "core0.h"
#include "core1.h"
#endif

/**
 * @name    MCAN subsystems references
 * @{
 */
#define MCAN_IP_VER              3U 
#define spc5_mcan                M_CAN_tag
#define CAN_SUB_0_RAM            0xF7ED4000UL
#define CAN_SUB_0_RAM_SIZE       15872U
#define CAN_SUB_1_RAM            0xFBED4000UL
#define CAN_SUB_1_RAM_SIZE       15872U
#define CAN_SUB_2_RAM            0xFFED4000UL
#define CAN_SUB_2_RAM_SIZE       15872U
#define CAN_SUB_3_RAM            0xFFED8000UL
#define CAN_SUB_3_RAM_SIZE       15872U
#define SPC5_MCAN_0              CAN_SUB_0_M_CAN_0
#define SPC5_MCAN_1              CAN_SUB_0_M_CAN_1
#define SPC5_MCAN_2              CAN_SUB_0_M_CAN_2
#define SPC5_MCAN_3              CAN_SUB_0_M_CAN_3
#define SPC5_MCAN_6              CAN_SUB_1_M_CAN_1
#define SPC5_MCAN_7              CAN_SUB_1_M_CAN_2
#define SPC5_MCAN_8              CAN_SUB_1_M_CAN_3
#define SPC5_MCAN_9              CAN_SUB_1_M_CAN_4
#define SPC5_MCAN_11             CAN_SUB_2_M_CAN_1
#define SPC5_MCAN_12             CAN_SUB_2_M_CAN_2
#define SPC5_MCAN_13             CAN_SUB_2_M_CAN_3
#define SPC5_MCAN_14             CAN_SUB_2_M_CAN_4
#define SPC5_MCAN_16             CAN_SUB_3_M_CAN_1
#define SPC5_MCAN_17             CAN_SUB_3_M_CAN_2
#define SPC5_MCAN_18             CAN_SUB_3_M_CAN_3
#define SPC5_MCAN_19             CAN_SUB_3_M_CAN_4
#define MCAN_ERROR_MASK          0x3FF60000UL
/** @} */

/**
 * @name    Clock Calibration Unit references
 * @{
 */
#define SPC5_CCCU_0              CCCU_0
/** @} */

/**
 * @name    SARDADC References
 *
 * @{
 */
#define SPC5_SARADC_HAS_ALT_REFERENCE  FALSE
#define spc5_saradc	                   SARADC_tag
#define SPC5_SARADC12_0                SAR_ADC_12BIT_0
#define SPC5_SARADC12_1                SAR_ADC_12BIT_1
#define SPC5_SARADC12_2                SAR_ADC_12BIT_2
#define SPC5_SARADC12_3                SAR_ADC_12BIT_3
#define SPC5_SARADC12_SV               SAR_ADC_12BIT_B0
#define SPC5_SARADC10_STANDBY          SAR_ADC_10BIT_STDBY
/** @} */

#endif /* _PLATFORM_H_ */
