/****************************************************************************
*
* Copyright © 2015-2019 STMicroelectronics - All Rights Reserved
*
* This software is licensed under SLA0098 terms that can be found in the
* DM00779817_1_0.pdf file in the licenses directory of this software product.
* 
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
*****************************************************************************/
/**
 * @file    spc5_pit.h
 * @brief   SPC5xx PIT header file.
 *
 * @addtogroup PIT
 * @{
 */

#ifndef _SPC5_PIT_H_
#define _SPC5_PIT_H_

/*===========================================================================*/
/* Driver constants.                                                         */
/*===========================================================================*/

/*===========================================================================*/
/* Driver pre-compile time settings.                                         */
/*===========================================================================*/

/*===========================================================================*/
/* Derived constants and error checks.                                       */
/*===========================================================================*/

/*===========================================================================*/
/* Driver data structures and types.                                         */
/*===========================================================================*/
/* PPC register definitions not compatible with MISRA rules on bit-fields 
   (Rules 6.1). */
/*lint -e46 */
/**
 * @brief   SPC5 PIT registers block.
 * @note    declaration of the SubModules registers among the various
 *
 */
    struct spc5_pit {
        union {
            vuint32_t R;
            struct {
                vuint32_t:30;
                vuint32_t MDIS:1;
                vuint32_t FRZ:1;
            } B;
        } PITMCR;

        uint32_t pit_reserved1[55];     /* (0xE0 - 0x04)/4 = 0x37 = 55 */

        union {
            vuint32_t R;
            struct {
                vuint32_t LMTRH:32;
            } B;
        } LMTRH;

        union {
            vuint32_t R;
            struct {
                vuint32_t LMTRL:32;
            } B;
        } LMTRL;

        uint32_t pit_reserved2[6];     /* (0x100 - 0x0E8)/4 = 0x6 = 6 */

        struct {
            union {
                vuint32_t R;
                struct {
                    vuint32_t TSV:32;
                } B;
            } LDVAL;

            union {
                vuint32_t R;
                struct {
                    vuint32_t TVL:32;
                } B;
            } CVAL;

            union {
                vuint32_t R;
                struct {
                    vuint32_t:30;
                    vuint32_t TIE:1;
                    vuint32_t TEN:1;
                } B;
            } TCTRL;

            union {
                vuint32_t R;
                struct {
                    vuint32_t:31;
                    vuint32_t TIF:1;
                } B;
            } TFLG;
        } CH[8];

    };                          
/*lint +e46 */

/*===========================================================================*/
/* Driver macros.                                                            */
/*===========================================================================*/

/**
 * @name    PIT units references
 * @{
 */
#if (SPC5_HAS_PIT0 == TRUE)
#define SPC5_PIT0          (*(volatile struct spc5_pit *)SPC5_PIT0_BASE)
#endif

#if (SPC5_HAS_PIT1 == TRUE)
#define SPC5_PIT1          (*(volatile struct spc5_pit *)SPC5_PIT1_BASE)
#endif
/** @} */

#endif /* _SPC5_PIT_H_ */

/** @} */
