/****************************************************************************
*
* Copyright © 2019 STMicroelectronics - All Rights Reserved
*
* This software is licensed under SLA0098 terms that can be found in the
* DM00779817_1_0.pdf file in the licenses directory of this software product.
* 
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED, 
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
*****************************************************************************/
/**
 * @file    octalspi_lld_cfg.h
 * @brief   OctalSPI Driver configuration macros and structures.
 *
 * @addtogroup OctalSPI
 * @{
 */

#ifndef _OCTALSPI_LLD_CFG_H_
#define _OCTALSPI_LLD_CFG_H_

#include <octalspi_lld.h>

#if (LLD_USE_OCTALSPI == TRUE) || defined(__DOXYGEN__)

/*===========================================================================*/
/* Driver constants.                                                         */
/*===========================================================================*/
#define OSPI_ICLK		8000000
#define OSPI_INSTANCES	2 						/**< @brief   OctalSPI enable two instances on Cut.2 SoC version */
#define	OSPI_PCTL		77						/**< @brief   OctalSPI IP peripheral enable */
#define OSPI_MEMTYPE	OSPI_MTYP_HYPERBUS_MEM	/**< @brief   HyperBusTM memory mode, the protocol follows the Cypress (Spansion) */
#define OSPI_FLASHSIZE	(32 * 1024 * 1024)		/**< @brief   HyperFlash size in bytes */
#define OSPI_RAMSIZE	(8  * 1024 * 1024)		/**< @brief   HyperRam size in bytes */
#define OSPI_MEMMODE	OSPI_MEM_MAPPED_MODE	/**< @brief   Default operational mode */

#endif /* LLD_USE_OCTALSPI */
#endif /* _OCTALSPI_LLD_CFG_H_ */

/** @} */
