/****************************************************************************
*
* Copyright © 2019 STMicroelectronics - All Rights Reserved
*
* This software is licensed under SLA0098 terms that can be found in the
* DM00779817_1_0.pdf file in the licenses directory of this software product.
* 
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED, 
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
*****************************************************************************/

/**
 * @file    lldconf.h
 * @brief   LLD configuration header.
 * @details LLD configuration file, this file allows to enable or disable the
 *          various device drivers from your application. You may also use
 *          this file in order to override the device drivers default settings.
 *
 * @addtogroup LLD_CONF
 * @{
 */

#ifndef _LLDCONF_H_
#define _LLDCONF_H_

/**
 * @name    Drivers enable switches
 */
#define LLD_USE_DMA                 TRUE
#define LLD_USE_PAL                 TRUE
#define LLD_USE_PIT                 TRUE
#define LLD_USE_STM                 FALSE
#define LLD_USE_SERIAL              FALSE
#define LLD_USE_PWM                 FALSE
#define LLD_USE_ICU                 FALSE
#define LLD_USE_CAN                 TRUE
#define LLD_USE_SPI                 FALSE
#define LLD_USE_ADC                 FALSE
#define LLD_USE_CTU                 FALSE
#define LLD_USE_I2C                 FALSE
#define LLD_USE_RTC                 FALSE
#define LLD_USE_SWT                 FALSE
#define LLD_USE_SARADC              FALSE
#define LLD_USE_CRC                 FALSE
#define LLD_USE_FCCU                FALSE
#define LLD_USE_WKPU                FALSE
#define LLD_USE_LIN                 FALSE
#define LLD_USE_I2S                 FALSE
#define LLD_USE_SEMA4               FALSE
#define LLD_USE_OCTALSPI            FALSE
#define LLD_USE_SDMMC               FALSE
/** @} */

/*===========================================================================*/
/**
 * @name SPI driver related setting
 * @{
 */
/*===========================================================================*/

/**
 * @brief   Enables synchronous APIs.
 * @note    Disabling this option saves both code and data space.
 */
#if !defined(SPI_USE_WAIT) || defined(__DOXYGEN__)
#define SPI_USE_WAIT                TRUE
#endif

/**
 * @brief   Enables the @p spiAcquireBus() and @p spiReleaseBus() APIs.
 * @note    Disabling this option saves both code and data space.
 */
#if !defined(SPI_USE_MUTUAL_EXCLUSION) || defined(__DOXYGEN__)
#define SPI_USE_MUTUAL_EXCLUSION    FALSE
#endif
/** @} */

/**
 * @name    SPI DMA modes
 * @{
 */
#define SPC5_SPI_DMA_NONE                   0
#define SPC5_SPI_DMA_RX_ONLY                1
#define SPC5_SPI_DMA_RX_AND_TX              2
/** @} */

/*===========================================================================*/
/**
 * @name SERIAL driver related setting
 * @{
 */
/*===========================================================================*/

/**
 * @name    SERIAL DMA modes
 * @{
 */
#define SPC5_SERIAL_DMA_OFF                 0
#define SPC5_SERIAL_DMA_ON                  1
/** @} */

/**
 * @name    LIN DMA modes
 * @{
 */
#define SPC5_LIN_DMA_OFF                    0
#define SPC5_LIN_DMA_ON                     1
/** @} */

/**
 * @name    LINFlex Mode Settings
 * @{
 */
#define SPC5_LINFLEX_MODE_NONE              0
#define SPC5_LINFLEX_MODE_SERIAL            1
#define SPC5_LINFLEX_MODE_LIN               2
/** @} */

/*
 * EDMA driver settings.
 */
#define SPC5_EDMA_CR_SETTING                (EDMA_CR_GRP1PRI(1) |           \
                                             EDMA_CR_GRP0PRI(0) |           \
                                             EDMA_CR_EMLM       |           \
                                             EDMA_CR_ERGA)
#define SPC5_EDMA1_GROUP0_PRIORITIES        0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15
#define SPC5_EDMA1_GROUP1_PRIORITIES        0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15
#define SPC5_EDMA1_GROUP2_PRIORITIES        0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15
#define SPC5_EDMA1_GROUP3_PRIORITIES        0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15
#define SPC5_EDMA1_GROUP4_PRIORITIES        0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15
#define SPC5_EDMA1_GROUP5_PRIORITIES        0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15
#define SPC5_EDMA_COMBO_CH_ERR_IRQ_PRIO     10

/*
 * SERIAL driver system settings.
 */
#define SPC5_LINFLEX0_SETTING               SPC5_LINFLEX_MODE_NONE
#define SPC5_LINFLEX1_SETTING               SPC5_LINFLEX_MODE_NONE
#define SPC5_LINFLEX2_SETTING               SPC5_LINFLEX_MODE_NONE
#define SPC5_LINFLEX3_SETTING               SPC5_LINFLEX_MODE_NONE
#define SPC5_LINFLEX4_SETTING               SPC5_LINFLEX_MODE_NONE
#define SPC5_LINFLEX5_SETTING               SPC5_LINFLEX_MODE_NONE
#define SPC5_LINFLEX6_SETTING               SPC5_LINFLEX_MODE_NONE
#define SPC5_LINFLEX7_SETTING               SPC5_LINFLEX_MODE_NONE
#define SPC5_LINFLEX8_SETTING               SPC5_LINFLEX_MODE_NONE
#define SPC5_LINFLEX9_SETTING               SPC5_LINFLEX_MODE_NONE
#define SPC5_LINFLEX10_SETTING               SPC5_LINFLEX_MODE_NONE
#define SPC5_LINFLEX11_SETTING               SPC5_LINFLEX_MODE_NONE
#define SPC5_LINFLEX12_SETTING               SPC5_LINFLEX_MODE_NONE
#define SPC5_LINFLEX13_SETTING               SPC5_LINFLEX_MODE_NONE
#define SPC5_LINFLEX14_SETTING               SPC5_LINFLEX_MODE_NONE
#define SPC5_LINFLEX15_SETTING               SPC5_LINFLEX_MODE_NONE
#define SPC5_LINFLEX16_SETTING               SPC5_LINFLEX_MODE_NONE
#define SPC5_LINFLEX17_SETTING               SPC5_LINFLEX_MODE_NONE
#define SPC5_LINFLEX18_SETTING               SPC5_LINFLEX_MODE_NONE
#define SPC5_LINFLEX19_SETTING               SPC5_LINFLEX_MODE_NONE
#define SPC5_LINFLEX20_SETTING               SPC5_LINFLEX_MODE_NONE
#define SPC5_LINFLEX21_SETTING               SPC5_LINFLEX_MODE_NONE
#define SPC5_LINFLEX22_SETTING               SPC5_LINFLEX_MODE_NONE
#define SPC5_LINFLEX23_SETTING               SPC5_LINFLEX_MODE_NONE
#define SPC5_LINFLEX0_PRIORITY              INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_LINFLEX1_PRIORITY              INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_LINFLEX2_PRIORITY              INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_LINFLEX3_PRIORITY              INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_LINFLEX4_PRIORITY              INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_LINFLEX5_PRIORITY              INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_LINFLEX6_PRIORITY              INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_LINFLEX7_PRIORITY              INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_LINFLEX8_PRIORITY              INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_LINFLEX9_PRIORITY              INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_LINFLEX10_PRIORITY             INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_LINFLEX11_PRIORITY             INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_LINFLEX12_PRIORITY             INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_LINFLEX13_PRIORITY             INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_LINFLEX14_PRIORITY             INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_LINFLEX15_PRIORITY             INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_LINFLEX16_PRIORITY             INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_LINFLEX17_PRIORITY             INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_LINFLEX18_PRIORITY             INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_LINFLEX19_PRIORITY             INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_LINFLEX20_PRIORITY             INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_LINFLEX21_PRIORITY             INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_LINFLEX22_PRIORITY             INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_LINFLEX23_PRIORITY             INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_SERIAL_DMA_MODE                SPC5_SERIAL_DMA_OFF
#define SPC5_LIN_DMA_MODE                   SPC5_LIN_DMA_OFF

#define SPC5_SERIAL_LINFLEX0_RX_DMA_CH_ID   0
#define SPC5_SERIAL_LINFLEX0_TX_DMA_CH_ID   1
#define SPC5_SERIAL_LINFLEX1_RX_DMA_CH_ID   2
#define SPC5_SERIAL_LINFLEX1_TX_DMA_CH_ID   3
#define SPC5_SERIAL_LINFLEX2_RX_DMA_CH_ID   4
#define SPC5_SERIAL_LINFLEX2_TX_DMA_CH_ID   5
#define SPC5_SERIAL_LINFLEX3_RX_DMA_CH_ID   16
#define SPC5_SERIAL_LINFLEX3_TX_DMA_CH_ID   17
#define SPC5_SERIAL_LINFLEX4_RX_DMA_CH_ID   18
#define SPC5_SERIAL_LINFLEX4_TX_DMA_CH_ID   19
#define SPC5_SERIAL_LINFLEX5_RX_DMA_CH_ID   20
#define SPC5_SERIAL_LINFLEX5_TX_DMA_CH_ID   21
#define SPC5_SERIAL_LINFLEX6_RX_DMA_CH_ID   22
#define SPC5_SERIAL_LINFLEX6_TX_DMA_CH_ID   23
#define SPC5_SERIAL_LINFLEX7_RX_DMA_CH_ID   6
#define SPC5_SERIAL_LINFLEX7_TX_DMA_CH_ID   7
#define SPC5_SERIAL_LINFLEX8_RX_DMA_CH_ID   24
#define SPC5_SERIAL_LINFLEX8_TX_DMA_CH_ID   25
#define SPC5_SERIAL_LINFLEX9_RX_DMA_CH_ID   26
#define SPC5_SERIAL_LINFLEX9_TX_DMA_CH_ID   27
#define SPC5_SERIAL_LINFLEX10_RX_DMA_CH_ID  8
#define SPC5_SERIAL_LINFLEX10_TX_DMA_CH_ID  9
#define SPC5_SERIAL_LINFLEX11_RX_DMA_CH_ID  32
#define SPC5_SERIAL_LINFLEX11_TX_DMA_CH_ID  33
#define SPC5_SERIAL_LINFLEX12_RX_DMA_CH_ID  34
#define SPC5_SERIAL_LINFLEX12_TX_DMA_CH_ID  35
#define SPC5_SERIAL_LINFLEX13_RX_DMA_CH_ID  48
#define SPC5_SERIAL_LINFLEX13_TX_DMA_CH_ID  49
#define SPC5_SERIAL_LINFLEX14_RX_DMA_CH_ID  50
#define SPC5_SERIAL_LINFLEX14_TX_DMA_CH_ID  51
#define SPC5_SERIAL_LINFLEX15_RX_DMA_CH_ID  10
#define SPC5_SERIAL_LINFLEX15_TX_DMA_CH_ID  11
#define SPC5_SERIAL_LINFLEX16_RX_DMA_CH_ID  36
#define SPC5_SERIAL_LINFLEX16_TX_DMA_CH_ID  37
#define SPC5_SERIAL_LINFLEX17_RX_DMA_CH_ID  52
#define SPC5_SERIAL_LINFLEX17_TX_DMA_CH_ID  53
#define SPC5_SERIAL_LINFLEX18_RX_DMA_CH_ID  12
#define SPC5_SERIAL_LINFLEX18_TX_DMA_CH_ID  13
#define SPC5_SERIAL_LINFLEX19_RX_DMA_CH_ID  14
#define SPC5_SERIAL_LINFLEX19_TX_DMA_CH_ID  15
#define SPC5_SERIAL_LINFLEX20_RX_DMA_CH_ID  28
#define SPC5_SERIAL_LINFLEX20_TX_DMA_CH_ID  29
#define SPC5_SERIAL_LINFLEX21_RX_DMA_CH_ID  30
#define SPC5_SERIAL_LINFLEX21_TX_DMA_CH_ID  31
#define SPC5_SERIAL_LINFLEX22_RX_DMA_CH_ID  38
#define SPC5_SERIAL_LINFLEX22_TX_DMA_CH_ID  39
#define SPC5_SERIAL_LINFLEX23_RX_DMA_CH_ID  54
#define SPC5_SERIAL_LINFLEX23_TX_DMA_CH_ID  55

#define SPC5_SERIAL_LINFLEX0_DMA_IRQ_PRIO   INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_SERIAL_LINFLEX1_DMA_IRQ_PRIO   INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_SERIAL_LINFLEX2_DMA_IRQ_PRIO   INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_SERIAL_LINFLEX3_DMA_IRQ_PRIO   INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_SERIAL_LINFLEX4_DMA_IRQ_PRIO   INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_SERIAL_LINFLEX5_DMA_IRQ_PRIO   INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_SERIAL_LINFLEX6_DMA_IRQ_PRIO   INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_SERIAL_LINFLEX7_DMA_IRQ_PRIO   INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_SERIAL_LINFLEX8_DMA_IRQ_PRIO   INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_SERIAL_LINFLEX9_DMA_IRQ_PRIO   INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_SERIAL_LINFLEX10_DMA_IRQ_PRIO  INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_SERIAL_LINFLEX11_DMA_IRQ_PRIO  INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_SERIAL_LINFLEX12_DMA_IRQ_PRIO  INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_SERIAL_LINFLEX13_DMA_IRQ_PRIO  INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_SERIAL_LINFLEX14_DMA_IRQ_PRIO  INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_SERIAL_LINFLEX15_DMA_IRQ_PRIO  INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_SERIAL_LINFLEX16_DMA_IRQ_PRIO  INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_SERIAL_LINFLEX17_DMA_IRQ_PRIO  INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_SERIAL_LINFLEX18_DMA_IRQ_PRIO  INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_SERIAL_LINFLEX19_DMA_IRQ_PRIO  INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_SERIAL_LINFLEX20_DMA_IRQ_PRIO  INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_SERIAL_LINFLEX21_DMA_IRQ_PRIO  INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_SERIAL_LINFLEX22_DMA_IRQ_PRIO  INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_SERIAL_LINFLEX23_DMA_IRQ_PRIO  INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)

#define SPC5_LINFLEX0_RX_DMA_MUX            0U
#define SPC5_LINFLEX0_RX_DMA_DEV_ID         SPC5_LINFLEX0_RX_DMA_MUX0_DEV_ID
#define SPC5_LINFLEX0_TX_DMA_MUX            0U
#define SPC5_LINFLEX0_TX_DMA_DEV_ID         SPC5_LINFLEX0_TX_DMA_MUX0_DEV_ID
#define SPC5_LINFLEX1_RX_DMA_MUX            0U
#define SPC5_LINFLEX1_RX_DMA_DEV_ID         SPC5_LINFLEX1_RX_DMA_MUX0_DEV_ID
#define SPC5_LINFLEX1_TX_DMA_MUX            0U
#define SPC5_LINFLEX1_TX_DMA_DEV_ID         SPC5_LINFLEX1_TX_DMA_MUX0_DEV_ID
#define SPC5_LINFLEX2_RX_DMA_MUX            0U
#define SPC5_LINFLEX2_RX_DMA_DEV_ID         SPC5_LINFLEX2_RX_DMA_MUX0_DEV_ID
#define SPC5_LINFLEX2_TX_DMA_MUX            0U
#define SPC5_LINFLEX2_TX_DMA_DEV_ID         SPC5_LINFLEX2_TX_DMA_MUX0_DEV_ID
#define SPC5_LINFLEX3_RX_DMA_MUX            1U
#define SPC5_LINFLEX3_RX_DMA_DEV_ID         SPC5_LINFLEX3_RX_DMA_MUX1_DEV_ID
#define SPC5_LINFLEX3_TX_DMA_MUX            1U
#define SPC5_LINFLEX3_TX_DMA_DEV_ID         SPC5_LINFLEX3_TX_DMA_MUX1_DEV_ID
#define SPC5_LINFLEX4_RX_DMA_MUX            1U
#define SPC5_LINFLEX4_RX_DMA_DEV_ID         SPC5_LINFLEX4_RX_DMA_MUX1_DEV_ID
#define SPC5_LINFLEX4_TX_DMA_MUX            1U
#define SPC5_LINFLEX4_TX_DMA_DEV_ID         SPC5_LINFLEX4_TX_DMA_MUX1_DEV_ID
#define SPC5_LINFLEX5_RX_DMA_MUX            1U
#define SPC5_LINFLEX5_RX_DMA_DEV_ID         SPC5_LINFLEX5_RX_DMA_MUX1_DEV_ID
#define SPC5_LINFLEX5_TX_DMA_MUX            1U
#define SPC5_LINFLEX5_TX_DMA_DEV_ID         SPC5_LINFLEX5_TX_DMA_MUX1_DEV_ID
#define SPC5_LINFLEX6_RX_DMA_MUX            1U
#define SPC5_LINFLEX6_RX_DMA_DEV_ID         SPC5_LINFLEX6_RX_DMA_MUX1_DEV_ID
#define SPC5_LINFLEX6_TX_DMA_MUX            1U
#define SPC5_LINFLEX6_TX_DMA_DEV_ID         SPC5_LINFLEX6_TX_DMA_MUX1_DEV_ID
#define SPC5_LINFLEX7_RX_DMA_MUX            0U
#define SPC5_LINFLEX7_RX_DMA_DEV_ID         SPC5_LINFLEX7_RX_DMA_MUX0_DEV_ID
#define SPC5_LINFLEX7_TX_DMA_MUX            0U
#define SPC5_LINFLEX7_TX_DMA_DEV_ID         SPC5_LINFLEX7_TX_DMA_MUX0_DEV_ID
#define SPC5_LINFLEX8_RX_DMA_MUX            1U
#define SPC5_LINFLEX8_RX_DMA_DEV_ID         SPC5_LINFLEX8_RX_DMA_MUX1_DEV_ID
#define SPC5_LINFLEX8_TX_DMA_MUX            1U
#define SPC5_LINFLEX8_TX_DMA_DEV_ID         SPC5_LINFLEX8_TX_DMA_MUX1_DEV_ID
#define SPC5_LINFLEX9_RX_DMA_MUX            1U
#define SPC5_LINFLEX9_RX_DMA_DEV_ID         SPC5_LINFLEX9_RX_DMA_MUX1_DEV_ID
#define SPC5_LINFLEX9_TX_DMA_MUX            1U
#define SPC5_LINFLEX9_TX_DMA_DEV_ID         SPC5_LINFLEX9_TX_DMA_MUX1_DEV_ID
#define SPC5_LINFLEX10_RX_DMA_MUX           0U
#define SPC5_LINFLEX10_RX_DMA_DEV_ID        SPC5_LINFLEX10_RX_DMA_MUX0_DEV_ID
#define SPC5_LINFLEX10_TX_DMA_MUX           0U
#define SPC5_LINFLEX10_TX_DMA_DEV_ID        SPC5_LINFLEX10_TX_DMA_MUX0_DEV_ID
#define SPC5_LINFLEX11_RX_DMA_MUX           2U
#define SPC5_LINFLEX11_RX_DMA_DEV_ID        SPC5_LINFLEX11_RX_DMA_MUX2_DEV_ID
#define SPC5_LINFLEX11_TX_DMA_MUX           2U
#define SPC5_LINFLEX11_TX_DMA_DEV_ID        SPC5_LINFLEX11_TX_DMA_MUX2_DEV_ID
#define SPC5_LINFLEX12_RX_DMA_MUX           2U
#define SPC5_LINFLEX12_RX_DMA_DEV_ID        SPC5_LINFLEX12_RX_DMA_MUX2_DEV_ID
#define SPC5_LINFLEX12_TX_DMA_MUX           2U
#define SPC5_LINFLEX12_TX_DMA_DEV_ID        SPC5_LINFLEX12_TX_DMA_MUX2_DEV_ID
#define SPC5_LINFLEX13_RX_DMA_MUX           3U
#define SPC5_LINFLEX13_RX_DMA_DEV_ID        SPC5_LINFLEX13_RX_DMA_MUX3_DEV_ID
#define SPC5_LINFLEX13_TX_DMA_MUX           3U
#define SPC5_LINFLEX13_TX_DMA_DEV_ID        SPC5_LINFLEX13_TX_DMA_MUX3_DEV_ID
#define SPC5_LINFLEX14_RX_DMA_MUX           3U
#define SPC5_LINFLEX14_RX_DMA_DEV_ID        SPC5_LINFLEX14_RX_DMA_MUX3_DEV_ID
#define SPC5_LINFLEX14_TX_DMA_MUX           3U
#define SPC5_LINFLEX14_TX_DMA_DEV_ID        SPC5_LINFLEX14_TX_DMA_MUX3_DEV_ID
#define SPC5_LINFLEX15_RX_DMA_MUX           0U
#define SPC5_LINFLEX15_RX_DMA_DEV_ID        SPC5_LINFLEX15_RX_DMA_MUX0_DEV_ID
#define SPC5_LINFLEX15_TX_DMA_MUX           0U
#define SPC5_LINFLEX15_TX_DMA_DEV_ID        SPC5_LINFLEX15_TX_DMA_MUX0_DEV_ID
#define SPC5_LINFLEX16_RX_DMA_MUX           2U
#define SPC5_LINFLEX16_RX_DMA_DEV_ID        SPC5_LINFLEX16_RX_DMA_MUX2_DEV_ID
#define SPC5_LINFLEX16_TX_DMA_MUX           2U
#define SPC5_LINFLEX16_TX_DMA_DEV_ID        SPC5_LINFLEX16_TX_DMA_MUX2_DEV_ID
#define SPC5_LINFLEX17_RX_DMA_MUX           3U
#define SPC5_LINFLEX17_RX_DMA_DEV_ID        SPC5_LINFLEX17_RX_DMA_MUX3_DEV_ID
#define SPC5_LINFLEX17_TX_DMA_MUX           3U
#define SPC5_LINFLEX17_TX_DMA_DEV_ID        SPC5_LINFLEX17_TX_DMA_MUX3_DEV_ID
#define SPC5_LINFLEX18_RX_DMA_MUX           0U
#define SPC5_LINFLEX18_RX_DMA_DEV_ID        SPC5_LINFLEX18_RX_DMA_MUX0_DEV_ID
#define SPC5_LINFLEX18_TX_DMA_MUX           0U
#define SPC5_LINFLEX18_TX_DMA_DEV_ID        SPC5_LINFLEX18_TX_DMA_MUX0_DEV_ID
#define SPC5_LINFLEX19_RX_DMA_MUX           0U
#define SPC5_LINFLEX19_RX_DMA_DEV_ID        SPC5_LINFLEX19_RX_DMA_MUX0_DEV_ID
#define SPC5_LINFLEX19_TX_DMA_MUX           0U
#define SPC5_LINFLEX19_TX_DMA_DEV_ID        SPC5_LINFLEX19_TX_DMA_MUX0_DEV_ID
#define SPC5_LINFLEX20_RX_DMA_MUX           1U
#define SPC5_LINFLEX20_RX_DMA_DEV_ID        SPC5_LINFLEX20_RX_DMA_MUX1_DEV_ID
#define SPC5_LINFLEX20_TX_DMA_MUX           1U
#define SPC5_LINFLEX20_TX_DMA_DEV_ID        SPC5_LINFLEX20_TX_DMA_MUX1_DEV_ID
#define SPC5_LINFLEX21_RX_DMA_MUX           1U
#define SPC5_LINFLEX21_RX_DMA_DEV_ID        SPC5_LINFLEX21_RX_DMA_MUX1_DEV_ID
#define SPC5_LINFLEX21_TX_DMA_MUX           1U
#define SPC5_LINFLEX21_TX_DMA_DEV_ID        SPC5_LINFLEX21_TX_DMA_MUX1_DEV_ID
#define SPC5_LINFLEX22_RX_DMA_MUX           2U
#define SPC5_LINFLEX22_RX_DMA_DEV_ID        SPC5_LINFLEX22_RX_DMA_MUX2_DEV_ID
#define SPC5_LINFLEX22_TX_DMA_MUX           2U
#define SPC5_LINFLEX22_TX_DMA_DEV_ID        SPC5_LINFLEX22_TX_DMA_MUX2_DEV_ID
#define SPC5_LINFLEX23_RX_DMA_MUX           3U
#define SPC5_LINFLEX23_RX_DMA_DEV_ID        SPC5_LINFLEX23_RX_DMA_MUX3_DEV_ID
#define SPC5_LINFLEX23_TX_DMA_MUX           3U
#define SPC5_LINFLEX23_TX_DMA_DEV_ID        SPC5_LINFLEX23_TX_DMA_MUX3_DEV_ID

/*
* PIT v2 driver system settings.
*/
#define SPC5_PIT_USE_PIT0                   TRUE
#define PIT0_CHANNEL_CH0_ENABLED            FALSE
#define PIT0_CHANNEL_CH1_ENABLED            TRUE
#define PIT0_CHANNEL_CH2_ENABLED            FALSE
#define PIT0_CHANNEL_CH3_ENABLED            FALSE
#define PIT0_CHANNEL_CH4_ENABLED            FALSE
#define PIT0_CHANNEL_CH5_ENABLED            FALSE
#define PIT0_CHANNEL_CH6_ENABLED            FALSE
#define PIT0_CHANNEL_CH7_ENABLED            FALSE
#define SPC5_PIT0_START_PCTL                (SPC5_ME_PCTL_RUN(2) |          \
                                             SPC5_ME_PCTL_LP(2))
#define SPC5_PIT0_STOP_PCTL                 (SPC5_ME_PCTL_RUN(0) |          \
                                             SPC5_ME_PCTL_LP(0))
#define SPC5_PIT0_CH0_IRQ_PRIO              INTC_PSR_ENABLE(INTC_PSR_CORE2, 4)
#define SPC5_PIT0_CH1_IRQ_PRIO              INTC_PSR_ENABLE(INTC_PSR_CORE2, 12)
#define SPC5_PIT0_CH2_IRQ_PRIO              INTC_PSR_ENABLE(INTC_PSR_CORE2, 12)
#define SPC5_PIT0_CH3_IRQ_PRIO              INTC_PSR_ENABLE(INTC_PSR_CORE2, 12)
#define SPC5_PIT0_CH4_IRQ_PRIO              INTC_PSR_ENABLE(INTC_PSR_CORE2, 12)
#define SPC5_PIT0_CH5_IRQ_PRIO              INTC_PSR_ENABLE(INTC_PSR_CORE2, 12)
#define SPC5_PIT0_CH6_IRQ_PRIO              INTC_PSR_ENABLE(INTC_PSR_CORE2, 12)
#define SPC5_PIT0_CH7_IRQ_PRIO              INTC_PSR_ENABLE(INTC_PSR_CORE2, 12)

#define SPC5_PIT_USE_PIT1                   FALSE
#define PIT1_CHANNEL_CH0_ENABLED            FALSE
#define PIT1_CHANNEL_CH1_ENABLED            FALSE
#define PIT1_CHANNEL_CH2_ENABLED            FALSE
#define PIT1_CHANNEL_CH3_ENABLED            FALSE
#define PIT1_CHANNEL_CH4_ENABLED            FALSE
#define PIT1_CHANNEL_CH5_ENABLED            FALSE
#define PIT1_CHANNEL_CH6_ENABLED            FALSE
#define PIT1_CHANNEL_CH7_ENABLED            FALSE
#define SPC5_PIT1_START_PCTL                (SPC5_ME_PCTL_RUN(2) |          \
                                             SPC5_ME_PCTL_LP(2))
#define SPC5_PIT1_STOP_PCTL                 (SPC5_ME_PCTL_RUN(0) |          \
                                             SPC5_ME_PCTL_LP(0))
#define SPC5_PIT1_CH0_IRQ_PRIO              INTC_PSR_ENABLE(INTC_PSR_CORE2, 12)
#define SPC5_PIT1_CH1_IRQ_PRIO              INTC_PSR_ENABLE(INTC_PSR_CORE2, 12)

/*
* STM driver system settings.
*/
#define SPC5_STM_USE_STM0                   FALSE
#define SPC5_STM0_SYSCLOCK_PRE              1
#define SPC5_STM0_CH0_ENABLED               FALSE
#define SPC5_STM0_CH0_IRQ_PRIORITY          INTC_PSR_ENABLE(INTC_PSR_CORE2, 11)  
#define SPC5_STM0_CH1_ENABLED               FALSE
#define SPC5_STM0_CH1_IRQ_PRIORITY          INTC_PSR_ENABLE(INTC_PSR_CORE2, 11)  
#define SPC5_STM0_CH2_ENABLED               FALSE
#define SPC5_STM0_CH2_IRQ_PRIORITY          INTC_PSR_ENABLE(INTC_PSR_CORE2, 11)  
#define SPC5_STM0_CH3_ENABLED               FALSE
#define SPC5_STM0_CH3_IRQ_PRIORITY          INTC_PSR_ENABLE(INTC_PSR_CORE2, 12)  
  
#define SPC5_STM_USE_STM1                   FALSE
#define SPC5_STM1_SYSCLOCK_PRE              1
#define SPC5_STM1_CH0_ENABLED               FALSE
#define SPC5_STM1_CH0_IRQ_PRIORITY          INTC_PSR_ENABLE(INTC_PSR_CORE2, 11)  
#define SPC5_STM1_CH1_ENABLED               FALSE
#define SPC5_STM1_CH1_IRQ_PRIORITY          INTC_PSR_ENABLE(INTC_PSR_CORE2, 11)  
#define SPC5_STM1_CH2_ENABLED               FALSE
#define SPC5_STM1_CH2_IRQ_PRIORITY          INTC_PSR_ENABLE(INTC_PSR_CORE2, 11)  
#define SPC5_STM1_CH3_ENABLED               FALSE
#define SPC5_STM1_CH3_IRQ_PRIORITY          INTC_PSR_ENABLE(INTC_PSR_CORE2, 12)  
  
#define SPC5_STM_USE_STM2                   FALSE
#define SPC5_STM2_SYSCLOCK_PRE              1
#define SPC5_STM2_CH0_ENABLED               FALSE
#define SPC5_STM2_CH0_IRQ_PRIORITY          INTC_PSR_ENABLE(INTC_PSR_CORE2, 11)  
#define SPC5_STM2_CH1_ENABLED               FALSE
#define SPC5_STM2_CH1_IRQ_PRIORITY          INTC_PSR_ENABLE(INTC_PSR_CORE2, 11)  
#define SPC5_STM2_CH2_ENABLED               FALSE
#define SPC5_STM2_CH2_IRQ_PRIORITY          INTC_PSR_ENABLE(INTC_PSR_CORE2, 11)  
#define SPC5_STM2_CH3_ENABLED               FALSE
#define SPC5_STM2_CH3_IRQ_PRIORITY          INTC_PSR_ENABLE(INTC_PSR_CORE2, 12)  
  
/*
 * SPI driver system settings.
 */
#define SPC5_SPI_USE_DSPI0                  FALSE
#define SPC5_SPI_USE_DSPI1                  FALSE
#define SPC5_SPI_USE_DSPI2                  FALSE
#define SPC5_SPI_USE_DSPI3                  FALSE
#define SPC5_SPI_USE_DSPI4                  FALSE
#define SPC5_SPI_USE_DSPI5                  FALSE
#define SPC5_SPI_USE_DSPI6                  FALSE
#define SPC5_SPI_USE_DSPI7                  FALSE
#define SPC5_SPI_USE_DSPI8                  FALSE
#define SPC5_SPI_USE_DSPI9                  FALSE

#define SPC5_SPI_DMA_MODE                   SPC5_SPI_DMA_NONE
#define SPC5_SPI_DSPI0_MCR                  (0U | SPC5_MCR_PCSIS0 | SPC5_MCR_PCSIS1 | SPC5_MCR_PCSIS2 | SPC5_MCR_PCSIS3 | SPC5_MCR_PCSIS4 | SPC5_MCR_PCSIS5 | SPC5_MCR_PCSIS6 | SPC5_MCR_PCSIS7)
#define SPC5_SPI_DSPI1_MCR                  (0U | SPC5_MCR_PCSIS0 | SPC5_MCR_PCSIS1 | SPC5_MCR_PCSIS2 | SPC5_MCR_PCSIS3 | SPC5_MCR_PCSIS4 | SPC5_MCR_PCSIS5 | SPC5_MCR_PCSIS6 | SPC5_MCR_PCSIS7)
#define SPC5_SPI_DSPI2_MCR                  (0U | SPC5_MCR_PCSIS0 | SPC5_MCR_PCSIS1 | SPC5_MCR_PCSIS2 | SPC5_MCR_PCSIS3 | SPC5_MCR_PCSIS4 | SPC5_MCR_PCSIS5 | SPC5_MCR_PCSIS6 | SPC5_MCR_PCSIS7)
#define SPC5_SPI_DSPI3_MCR                  (0U | SPC5_MCR_PCSIS0 | SPC5_MCR_PCSIS1 | SPC5_MCR_PCSIS2 | SPC5_MCR_PCSIS3 | SPC5_MCR_PCSIS4 | SPC5_MCR_PCSIS5 | SPC5_MCR_PCSIS6 | SPC5_MCR_PCSIS7)
#define SPC5_SPI_DSPI4_MCR                  (0U | SPC5_MCR_PCSIS0 | SPC5_MCR_PCSIS1 | SPC5_MCR_PCSIS2 | SPC5_MCR_PCSIS3 | SPC5_MCR_PCSIS4 | SPC5_MCR_PCSIS5 | SPC5_MCR_PCSIS6 | SPC5_MCR_PCSIS7)
#define SPC5_SPI_DSPI5_MCR                  (0U | SPC5_MCR_PCSIS0 | SPC5_MCR_PCSIS1 | SPC5_MCR_PCSIS2 | SPC5_MCR_PCSIS3 | SPC5_MCR_PCSIS4 | SPC5_MCR_PCSIS5 | SPC5_MCR_PCSIS6 | SPC5_MCR_PCSIS7)
#define SPC5_SPI_DSPI6_MCR                  (0U | SPC5_MCR_PCSIS0 | SPC5_MCR_PCSIS1 | SPC5_MCR_PCSIS2 | SPC5_MCR_PCSIS3 | SPC5_MCR_PCSIS4 | SPC5_MCR_PCSIS5 | SPC5_MCR_PCSIS6 | SPC5_MCR_PCSIS7)
#define SPC5_SPI_DSPI7_MCR                  (0U | SPC5_MCR_PCSIS0 | SPC5_MCR_PCSIS1 | SPC5_MCR_PCSIS2 | SPC5_MCR_PCSIS3 | SPC5_MCR_PCSIS4 | SPC5_MCR_PCSIS5 | SPC5_MCR_PCSIS6 | SPC5_MCR_PCSIS7)
#define SPC5_SPI_DSPI8_MCR                  (0U | SPC5_MCR_PCSIS0 | SPC5_MCR_PCSIS1 | SPC5_MCR_PCSIS2 | SPC5_MCR_PCSIS3 | SPC5_MCR_PCSIS4 | SPC5_MCR_PCSIS5 | SPC5_MCR_PCSIS6 | SPC5_MCR_PCSIS7)
#define SPC5_SPI_DSPI9_MCR                  (0U | SPC5_MCR_PCSIS0 | SPC5_MCR_PCSIS1 | SPC5_MCR_PCSIS2 | SPC5_MCR_PCSIS3 | SPC5_MCR_PCSIS4 | SPC5_MCR_PCSIS5 | SPC5_MCR_PCSIS6 | SPC5_MCR_PCSIS7)

#define SPC5_SPI_DSPI0_IRQ_PRIO             INTC_PSR_ENABLE(INTC_PSR_CORE2, 10) 
#define SPC5_SPI_DSPI1_IRQ_PRIO             INTC_PSR_ENABLE(INTC_PSR_CORE2, 10)
#define SPC5_SPI_DSPI2_IRQ_PRIO             INTC_PSR_ENABLE(INTC_PSR_CORE2, 10)
#define SPC5_SPI_DSPI3_IRQ_PRIO             INTC_PSR_ENABLE(INTC_PSR_CORE2, 10)
#define SPC5_SPI_DSPI4_IRQ_PRIO             INTC_PSR_ENABLE(INTC_PSR_CORE2, 10)
#define SPC5_SPI_DSPI5_IRQ_PRIO             INTC_PSR_ENABLE(INTC_PSR_CORE2, 10)
#define SPC5_SPI_DSPI6_IRQ_PRIO             INTC_PSR_ENABLE(INTC_PSR_CORE2, 10)
#define SPC5_SPI_DSPI7_IRQ_PRIO             INTC_PSR_ENABLE(INTC_PSR_CORE2, 10)
#define SPC5_SPI_DSPI8_IRQ_PRIO             INTC_PSR_ENABLE(INTC_PSR_CORE2, 10)
#define SPC5_SPI_DSPI9_IRQ_PRIO             INTC_PSR_ENABLE(INTC_PSR_CORE2, 10)

#define SPC5_SPI_DSPI0_RX_DMA_CH_ID         0
#define SPC5_SPI_DSPI0_TX1_DMA_CH_ID        1
#define SPC5_SPI_DSPI0_TX2_DMA_CH_ID        2
#define SPC5_SPI_DSPI1_RX_DMA_CH_ID         3
#define SPC5_SPI_DSPI1_TX1_DMA_CH_ID        4
#define SPC5_SPI_DSPI1_TX2_DMA_CH_ID        5
#define SPC5_SPI_DSPI2_RX_DMA_CH_ID         6
#define SPC5_SPI_DSPI2_TX1_DMA_CH_ID        7
#define SPC5_SPI_DSPI2_TX2_DMA_CH_ID        8
#define SPC5_SPI_DSPI3_RX_DMA_CH_ID         9
#define SPC5_SPI_DSPI3_TX1_DMA_CH_ID        10
#define SPC5_SPI_DSPI3_TX2_DMA_CH_ID        11
#define SPC5_SPI_DSPI4_RX_DMA_CH_ID         16
#define SPC5_SPI_DSPI4_TX1_DMA_CH_ID        17
#define SPC5_SPI_DSPI4_TX2_DMA_CH_ID        18
#define SPC5_SPI_DSPI5_RX_DMA_CH_ID         19
#define SPC5_SPI_DSPI5_TX1_DMA_CH_ID        20
#define SPC5_SPI_DSPI5_TX2_DMA_CH_ID        21
#define SPC5_SPI_DSPI6_RX_DMA_CH_ID         22
#define SPC5_SPI_DSPI6_TX1_DMA_CH_ID        23
#define SPC5_SPI_DSPI6_TX2_DMA_CH_ID        24
#define SPC5_SPI_DSPI7_RX_DMA_CH_ID         32
#define SPC5_SPI_DSPI7_TX1_DMA_CH_ID        33
#define SPC5_SPI_DSPI7_TX2_DMA_CH_ID        34
#define SPC5_SPI_DSPI8_RX_DMA_CH_ID         12
#define SPC5_SPI_DSPI8_TX1_DMA_CH_ID        13
#define SPC5_SPI_DSPI8_TX2_DMA_CH_ID        14
#define SPC5_SPI_DSPI9_RX_DMA_CH_ID         35
#define SPC5_SPI_DSPI9_TX1_DMA_CH_ID        36
#define SPC5_SPI_DSPI9_TX2_DMA_CH_ID        37

#define SPC5_SPI_DSPI0_DMA_IRQ_PRIO         INTC_PSR_ENABLE(INTC_PSR_CORE2, 10) 
#define SPC5_SPI_DSPI1_DMA_IRQ_PRIO         INTC_PSR_ENABLE(INTC_PSR_CORE2, 10)
#define SPC5_SPI_DSPI2_DMA_IRQ_PRIO         INTC_PSR_ENABLE(INTC_PSR_CORE2, 10)
#define SPC5_SPI_DSPI3_DMA_IRQ_PRIO         INTC_PSR_ENABLE(INTC_PSR_CORE2, 10)
#define SPC5_SPI_DSPI4_DMA_IRQ_PRIO         INTC_PSR_ENABLE(INTC_PSR_CORE2, 10)
#define SPC5_SPI_DSPI5_DMA_IRQ_PRIO         INTC_PSR_ENABLE(INTC_PSR_CORE2, 10)
#define SPC5_SPI_DSPI6_DMA_IRQ_PRIO         INTC_PSR_ENABLE(INTC_PSR_CORE2, 10)
#define SPC5_SPI_DSPI7_DMA_IRQ_PRIO         INTC_PSR_ENABLE(INTC_PSR_CORE2, 10)
#define SPC5_SPI_DSPI8_DMA_IRQ_PRIO         INTC_PSR_ENABLE(INTC_PSR_CORE2, 10)
#define SPC5_SPI_DSPI9_DMA_IRQ_PRIO         INTC_PSR_ENABLE(INTC_PSR_CORE2, 10)

#define SPC5_DSPI0_RX_DMA_MUX               0U
#define SPC5_DSPI0_RX_DMA_DEV_ID            SPC5_DSPI0_RX_DMA_MUX0_DEV_ID
#define SPC5_DSPI0_TX1_DMA_MUX              0U
#define SPC5_DSPI0_TX1_DMA_DEV_ID           SPC5_DSPI0_TX1_DMA_MUX0_DEV_ID
#define SPC5_DSPI0_TX2_DMA_MUX              0U
#define SPC5_DSPI0_TX2_DMA_DEV_ID           SPC5_DSPI0_TX2_DMA_MUX0_DEV_ID
#define SPC5_DSPI1_RX_DMA_MUX               0U
#define SPC5_DSPI1_RX_DMA_DEV_ID            SPC5_DSPI1_RX_DMA_MUX0_DEV_ID
#define SPC5_DSPI1_TX1_DMA_MUX              0U
#define SPC5_DSPI1_TX1_DMA_DEV_ID           SPC5_DSPI1_TX1_DMA_MUX0_DEV_ID
#define SPC5_DSPI1_TX2_DMA_MUX              0U
#define SPC5_DSPI1_TX2_DMA_DEV_ID           SPC5_DSPI1_TX2_DMA_MUX0_DEV_ID
#define SPC5_DSPI2_RX_DMA_MUX               0U
#define SPC5_DSPI2_RX_DMA_DEV_ID            SPC5_DSPI2_RX_DMA_MUX0_DEV_ID
#define SPC5_DSPI2_TX1_DMA_MUX              0U
#define SPC5_DSPI2_TX1_DMA_DEV_ID           SPC5_DSPI2_TX1_DMA_MUX0_DEV_ID
#define SPC5_DSPI2_TX2_DMA_MUX              0U
#define SPC5_DSPI2_TX2_DMA_DEV_ID           SPC5_DSPI2_TX2_DMA_MUX0_DEV_ID
#define SPC5_DSPI3_RX_DMA_MUX               0U
#define SPC5_DSPI3_RX_DMA_DEV_ID            SPC5_DSPI3_RX_DMA_MUX0_DEV_ID
#define SPC5_DSPI3_TX1_DMA_MUX              0U
#define SPC5_DSPI3_TX1_DMA_DEV_ID           SPC5_DSPI3_TX1_DMA_MUX0_DEV_ID
#define SPC5_DSPI3_TX2_DMA_MUX              0U
#define SPC5_DSPI3_TX2_DMA_DEV_ID           SPC5_DSPI3_TX2_DMA_MUX0_DEV_ID
#define SPC5_DSPI4_RX_DMA_MUX               1U
#define SPC5_DSPI4_RX_DMA_DEV_ID            SPC5_DSPI4_RX_DMA_MUX1_DEV_ID
#define SPC5_DSPI4_TX1_DMA_MUX              1U
#define SPC5_DSPI4_TX1_DMA_DEV_ID           SPC5_DSPI4_TX1_DMA_MUX1_DEV_ID
#define SPC5_DSPI4_TX2_DMA_MUX              1U
#define SPC5_DSPI4_TX2_DMA_DEV_ID           SPC5_DSPI4_TX2_DMA_MUX1_DEV_ID
#define SPC5_DSPI5_RX_DMA_MUX               1U
#define SPC5_DSPI5_RX_DMA_DEV_ID            SPC5_DSPI5_RX_DMA_MUX1_DEV_ID
#define SPC5_DSPI5_TX1_DMA_MUX              1U
#define SPC5_DSPI5_TX1_DMA_DEV_ID           SPC5_DSPI5_TX1_DMA_MUX1_DEV_ID
#define SPC5_DSPI5_TX2_DMA_MUX              1U
#define SPC5_DSPI5_TX2_DMA_DEV_ID           SPC5_DSPI5_TX2_DMA_MUX1_DEV_ID
#define SPC5_DSPI6_RX_DMA_MUX               1U
#define SPC5_DSPI6_RX_DMA_DEV_ID            SPC5_DSPI6_RX_DMA_MUX1_DEV_ID
#define SPC5_DSPI6_TX1_DMA_MUX              1U
#define SPC5_DSPI6_TX1_DMA_DEV_ID           SPC5_DSPI6_TX1_DMA_MUX1_DEV_ID
#define SPC5_DSPI6_TX2_DMA_MUX              1U
#define SPC5_DSPI6_TX2_DMA_DEV_ID           SPC5_DSPI6_TX2_DMA_MUX1_DEV_ID
#define SPC5_DSPI7_RX_DMA_MUX               2U
#define SPC5_DSPI7_RX_DMA_DEV_ID            SPC5_DSPI7_RX_DMA_MUX2_DEV_ID
#define SPC5_DSPI7_TX1_DMA_MUX              2U
#define SPC5_DSPI7_TX1_DMA_DEV_ID           SPC5_DSPI7_TX1_DMA_MUX2_DEV_ID
#define SPC5_DSPI7_TX2_DMA_MUX              2U
#define SPC5_DSPI7_TX2_DMA_DEV_ID           SPC5_DSPI7_TX2_DMA_MUX2_DEV_ID
#define SPC5_DSPI8_RX_DMA_MUX               0U
#define SPC5_DSPI8_RX_DMA_DEV_ID            SPC5_DSPI8_RX_DMA_MUX0_DEV_ID
#define SPC5_DSPI8_TX1_DMA_MUX              0U
#define SPC5_DSPI8_TX1_DMA_DEV_ID           SPC5_DSPI8_TX1_DMA_MUX0_DEV_ID
#define SPC5_DSPI8_TX2_DMA_MUX              0U
#define SPC5_DSPI8_TX2_DMA_DEV_ID           SPC5_DSPI8_TX2_DMA_MUX0_DEV_ID
#define SPC5_DSPI9_RX_DMA_MUX               2U
#define SPC5_DSPI9_RX_DMA_DEV_ID            SPC5_DSPI9_RX_DMA_MUX2_DEV_ID
#define SPC5_DSPI9_TX1_DMA_MUX              2U
#define SPC5_DSPI9_TX1_DMA_DEV_ID           SPC5_DSPI9_TX1_DMA_MUX2_DEV_ID
#define SPC5_DSPI9_TX2_DMA_MUX              2U
#define SPC5_DSPI9_TX2_DMA_DEV_ID           SPC5_DSPI9_TX2_DMA_MUX2_DEV_ID

/*
 * I2S driver system settings.
 */
#define SPC5_I2S_USE_DSPI0                  FALSE
#define SPC5_I2S_USE_DSPI1                  FALSE
#define SPC5_I2S_USE_DSPI2                  FALSE
#define SPC5_I2S_USE_DSPI3                  FALSE
#define SPC5_I2S_USE_DSPI4                  FALSE
#define SPC5_I2S_USE_DSPI5                  FALSE
#define SPC5_I2S_USE_DSPI6                  FALSE
#define SPC5_I2S_USE_DSPI7                  FALSE
#define SPC5_I2S_USE_DSPI8                  FALSE
#define SPC5_I2S_USE_DSPI9                  FALSE

#define I2S_USE_WAIT                        TRUE

#define SPC5_I2S_DSPI0_IRQ_PRIO             INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10)
#define SPC5_I2S_DSPI1_IRQ_PRIO             INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10)
#define SPC5_I2S_DSPI2_IRQ_PRIO             INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10)
#define SPC5_I2S_DSPI3_IRQ_PRIO             INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10)
#define SPC5_I2S_DSPI4_IRQ_PRIO             INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10)
#define SPC5_I2S_DSPI5_IRQ_PRIO             INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10)
#define SPC5_I2S_DSPI6_IRQ_PRIO             INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10)
#define SPC5_I2S_DSPI7_IRQ_PRIO             INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10)
#define SPC5_I2S_DSPI8_IRQ_PRIO             INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10)
#define SPC5_I2S_DSPI9_IRQ_PRIO             INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10)

#define SPC5_I2S_DSPI0_RX_DMA_CH_ID         0
#define SPC5_I2S_DSPI0_TX1_DMA_CH_ID        1
#define SPC5_I2S_DSPI0_TX2_DMA_CH_ID        2
#define SPC5_I2S_DSPI1_RX_DMA_CH_ID         3
#define SPC5_I2S_DSPI1_TX1_DMA_CH_ID        4
#define SPC5_I2S_DSPI1_TX2_DMA_CH_ID        5
#define SPC5_I2S_DSPI2_RX_DMA_CH_ID         6
#define SPC5_I2S_DSPI2_TX1_DMA_CH_ID        7
#define SPC5_I2S_DSPI2_TX2_DMA_CH_ID        8
#define SPC5_I2S_DSPI3_RX_DMA_CH_ID         9
#define SPC5_I2S_DSPI3_TX1_DMA_CH_ID        10
#define SPC5_I2S_DSPI3_TX2_DMA_CH_ID        11
#define SPC5_I2S_DSPI4_RX_DMA_CH_ID         16
#define SPC5_I2S_DSPI4_TX1_DMA_CH_ID        17
#define SPC5_I2S_DSPI4_TX2_DMA_CH_ID        18
#define SPC5_I2S_DSPI5_RX_DMA_CH_ID         19
#define SPC5_I2S_DSPI5_TX1_DMA_CH_ID        20
#define SPC5_I2S_DSPI5_TX2_DMA_CH_ID        21
#define SPC5_I2S_DSPI6_RX_DMA_CH_ID         22
#define SPC5_I2S_DSPI6_TX1_DMA_CH_ID        23
#define SPC5_I2S_DSPI6_TX2_DMA_CH_ID        24
#define SPC5_I2S_DSPI7_RX_DMA_CH_ID         32
#define SPC5_I2S_DSPI7_TX1_DMA_CH_ID        33
#define SPC5_I2S_DSPI7_TX2_DMA_CH_ID        34
#define SPC5_I2S_DSPI8_RX_DMA_CH_ID         12
#define SPC5_I2S_DSPI8_TX1_DMA_CH_ID        13
#define SPC5_I2S_DSPI8_TX2_DMA_CH_ID        14
#define SPC5_I2S_DSPI9_RX_DMA_CH_ID         35
#define SPC5_I2S_DSPI9_TX1_DMA_CH_ID        36
#define SPC5_I2S_DSPI9_TX2_DMA_CH_ID        37

#define SPC5_I2S_DSPI0_DMA_IRQ_PRIO         INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10) 
#define SPC5_I2S_DSPI1_DMA_IRQ_PRIO         INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10)
#define SPC5_I2S_DSPI2_DMA_IRQ_PRIO         INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10)
#define SPC5_I2S_DSPI3_DMA_IRQ_PRIO         INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10)
#define SPC5_I2S_DSPI4_DMA_IRQ_PRIO         INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10) 
#define SPC5_I2S_DSPI5_DMA_IRQ_PRIO         INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10)
#define SPC5_I2S_DSPI6_DMA_IRQ_PRIO         INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10)
#define SPC5_I2S_DSPI7_DMA_IRQ_PRIO         INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10)
#define SPC5_I2S_DSPI8_DMA_IRQ_PRIO         INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10)
#define SPC5_I2S_DSPI9_DMA_IRQ_PRIO         INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10)

/*
 * CAN SUBSYSTEM driver system settings.
*/
#define SPC5_USE_CAN_SUB_0_M_CAN_0          FALSE
#define SPC5_CAN_SUB_0_M_CAN_0_START_PTCL   (SPC5_ME_PCTL_RUN(2) | SPC5_ME_PCTL_LP(2))
#define SPC5_CAN_SUB_0_M_CAN_0_STOP_PTCL    (SPC5_ME_PCTL_RUN(0) | SPC5_ME_PCTL_LP(0))
#define SPC5_CAN_SUB_0_M_CAN_0_L0_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_0_M_CAN_0_L1_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_0_M_CAN_0_RAM_START    0UL
#define SPC5_CAN_SUB_0_M_CAN_0_RAM_SIZE     0UL

#define SPC5_USE_CAN_SUB_0_M_CAN_1          FALSE
#define SPC5_CAN_SUB_0_M_CAN_1_START_PTCL   (SPC5_ME_PCTL_RUN(2) | SPC5_ME_PCTL_LP(2))
#define SPC5_CAN_SUB_0_M_CAN_1_STOP_PTCL    (SPC5_ME_PCTL_RUN(0) | SPC5_ME_PCTL_LP(0))
#define SPC5_CAN_SUB_0_M_CAN_1_L0_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_0_M_CAN_1_L1_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_0_M_CAN_1_RAM_START    SPC5_CAN_SUB_0_M_CAN_0_RAM_START + SPC5_CAN_SUB_0_M_CAN_0_RAM_SIZE
#define SPC5_CAN_SUB_0_M_CAN_1_RAM_SIZE     0UL

#define SPC5_USE_CAN_SUB_0_M_CAN_2          FALSE
#define SPC5_CAN_SUB_0_M_CAN_2_START_PTCL   (SPC5_ME_PCTL_RUN(2) | SPC5_ME_PCTL_LP(2))
#define SPC5_CAN_SUB_0_M_CAN_2_STOP_PTCL    (SPC5_ME_PCTL_RUN(0) | SPC5_ME_PCTL_LP(0))
#define SPC5_CAN_SUB_0_M_CAN_2_L0_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_0_M_CAN_2_L1_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_0_M_CAN_2_RAM_START    SPC5_CAN_SUB_0_M_CAN_1_RAM_START + SPC5_CAN_SUB_0_M_CAN_1_RAM_SIZE
#define SPC5_CAN_SUB_0_M_CAN_2_RAM_SIZE     0UL

#define SPC5_USE_CAN_SUB_0_M_CAN_3          TRUE
#define SPC5_CAN_SUB_0_M_CAN_3_START_PTCL   (SPC5_ME_PCTL_RUN(2) | SPC5_ME_PCTL_LP(2))
#define SPC5_CAN_SUB_0_M_CAN_3_STOP_PTCL    (SPC5_ME_PCTL_RUN(0) | SPC5_ME_PCTL_LP(0))
#define SPC5_CAN_SUB_0_M_CAN_3_L0_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_0_M_CAN_3_L1_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_0_M_CAN_3_RAM_START    SPC5_CAN_SUB_0_M_CAN_2_RAM_START + SPC5_CAN_SUB_0_M_CAN_2_RAM_SIZE
#define SPC5_CAN_SUB_0_M_CAN_3_RAM_SIZE     3968UL


#define SPC5_CAN_SUB_0_RAM_START_PTCL       (SPC5_ME_PCTL_RUN(2) | SPC5_ME_PCTL_LP(2))
#define SPC5_CAN_SUB_0_RAM_STOP_PTCL        (SPC5_ME_PCTL_RUN(0) | SPC5_ME_PCTL_LP(0))

#define SPC5_USE_CAN_SUB_1_M_CAN_1          FALSE
#define SPC5_CAN_SUB_1_M_CAN_1_START_PTCL   (SPC5_ME_PCTL_RUN(2) | SPC5_ME_PCTL_LP(2))
#define SPC5_CAN_SUB_1_M_CAN_1_STOP_PTCL    (SPC5_ME_PCTL_RUN(0) | SPC5_ME_PCTL_LP(0))
#define SPC5_CAN_SUB_1_M_CAN_1_L0_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_1_M_CAN_1_L1_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_1_M_CAN_1_RAM_START    0UL
#define SPC5_CAN_SUB_1_M_CAN_1_RAM_SIZE     0UL

#define SPC5_USE_CAN_SUB_1_M_CAN_2          FALSE
#define SPC5_CAN_SUB_1_M_CAN_2_START_PTCL   (SPC5_ME_PCTL_RUN(2) | SPC5_ME_PCTL_LP(2))
#define SPC5_CAN_SUB_1_M_CAN_2_STOP_PTCL    (SPC5_ME_PCTL_RUN(0) | SPC5_ME_PCTL_LP(0))
#define SPC5_CAN_SUB_1_M_CAN_2_L0_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_1_M_CAN_2_L1_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_1_M_CAN_2_RAM_START    SPC5_CAN_SUB_1_M_CAN_1_RAM_START + SPC5_CAN_SUB_1_M_CAN_1_RAM_SIZE
#define SPC5_CAN_SUB_1_M_CAN_2_RAM_SIZE     0UL

#define SPC5_USE_CAN_SUB_1_M_CAN_3          FALSE
#define SPC5_CAN_SUB_1_M_CAN_3_START_PTCL   (SPC5_ME_PCTL_RUN(2) | SPC5_ME_PCTL_LP(2))
#define SPC5_CAN_SUB_1_M_CAN_3_STOP_PTCL    (SPC5_ME_PCTL_RUN(0) | SPC5_ME_PCTL_LP(0))
#define SPC5_CAN_SUB_1_M_CAN_3_L0_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_1_M_CAN_3_L1_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_1_M_CAN_3_RAM_START    SPC5_CAN_SUB_1_M_CAN_2_RAM_START + SPC5_CAN_SUB_1_M_CAN_2_RAM_SIZE
#define SPC5_CAN_SUB_1_M_CAN_3_RAM_SIZE     0UL

#define SPC5_USE_CAN_SUB_1_M_CAN_4          FALSE
#define SPC5_CAN_SUB_1_M_CAN_4_START_PTCL   (SPC5_ME_PCTL_RUN(2) | SPC5_ME_PCTL_LP(2))
#define SPC5_CAN_SUB_1_M_CAN_4_STOP_PTCL    (SPC5_ME_PCTL_RUN(0) | SPC5_ME_PCTL_LP(0))
#define SPC5_CAN_SUB_1_M_CAN_4_L0_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_1_M_CAN_4_L1_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_1_M_CAN_4_RAM_START    SPC5_CAN_SUB_1_M_CAN_3_RAM_START + SPC5_CAN_SUB_1_M_CAN_3_RAM_SIZE
#define SPC5_CAN_SUB_1_M_CAN_4_RAM_SIZE     0UL

#define SPC5_CAN_SUB_1_RAM_START_PTCL       (SPC5_ME_PCTL_RUN(2) | SPC5_ME_PCTL_LP(2))
#define SPC5_CAN_SUB_1_RAM_STOP_PTCL        (SPC5_ME_PCTL_RUN(0) | SPC5_ME_PCTL_LP(0))

#define SPC5_USE_CAN_SUB_2_M_CAN_1          FALSE
#define SPC5_CAN_SUB_2_M_CAN_1_START_PTCL   (SPC5_ME_PCTL_RUN(2) | SPC5_ME_PCTL_LP(2))
#define SPC5_CAN_SUB_2_M_CAN_1_STOP_PTCL    (SPC5_ME_PCTL_RUN(0) | SPC5_ME_PCTL_LP(0))
#define SPC5_CAN_SUB_2_M_CAN_1_L0_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_2_M_CAN_1_L1_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_2_M_CAN_1_RAM_START    0UL
#define SPC5_CAN_SUB_2_M_CAN_1_RAM_SIZE     0UL

#define SPC5_USE_CAN_SUB_2_M_CAN_2          FALSE
#define SPC5_CAN_SUB_2_M_CAN_2_START_PTCL   (SPC5_ME_PCTL_RUN(2) | SPC5_ME_PCTL_LP(2))
#define SPC5_CAN_SUB_2_M_CAN_2_STOP_PTCL    (SPC5_ME_PCTL_RUN(0) | SPC5_ME_PCTL_LP(0))
#define SPC5_CAN_SUB_2_M_CAN_2_L0_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_2_M_CAN_2_L1_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_2_M_CAN_2_RAM_START    SPC5_CAN_SUB_2_M_CAN_1_RAM_START + SPC5_CAN_SUB_2_M_CAN_1_RAM_SIZE
#define SPC5_CAN_SUB_2_M_CAN_2_RAM_SIZE     0UL

#define SPC5_USE_CAN_SUB_2_M_CAN_3          FALSE
#define SPC5_CAN_SUB_2_M_CAN_3_START_PTCL   (SPC5_ME_PCTL_RUN(2) | SPC5_ME_PCTL_LP(2))
#define SPC5_CAN_SUB_2_M_CAN_3_STOP_PTCL    (SPC5_ME_PCTL_RUN(0) | SPC5_ME_PCTL_LP(0))
#define SPC5_CAN_SUB_2_M_CAN_3_L0_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_2_M_CAN_3_L1_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_2_M_CAN_3_RAM_START    SPC5_CAN_SUB_2_M_CAN_2_RAM_START + SPC5_CAN_SUB_2_M_CAN_2_RAM_SIZE
#define SPC5_CAN_SUB_2_M_CAN_3_RAM_SIZE     0UL

#define SPC5_USE_CAN_SUB_2_M_CAN_4          FALSE
#define SPC5_CAN_SUB_2_M_CAN_4_START_PTCL   (SPC5_ME_PCTL_RUN(2) | SPC5_ME_PCTL_LP(2))
#define SPC5_CAN_SUB_2_M_CAN_4_STOP_PTCL    (SPC5_ME_PCTL_RUN(0) | SPC5_ME_PCTL_LP(0))
#define SPC5_CAN_SUB_2_M_CAN_4_L0_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_2_M_CAN_4_L1_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_2_M_CAN_4_RAM_START    SPC5_CAN_SUB_2_M_CAN_3_RAM_START + SPC5_CAN_SUB_2_M_CAN_3_RAM_SIZE
#define SPC5_CAN_SUB_2_M_CAN_4_RAM_SIZE     0UL

#define SPC5_CAN_SUB_2_RAM_START_PTCL       (SPC5_ME_PCTL_RUN(2) | SPC5_ME_PCTL_LP(2))
#define SPC5_CAN_SUB_2_RAM_STOP_PTCL        (SPC5_ME_PCTL_RUN(0) | SPC5_ME_PCTL_LP(0))

#define SPC5_USE_CAN_SUB_3_M_CAN_1          FALSE
#define SPC5_CAN_SUB_3_M_CAN_1_START_PTCL   (SPC5_ME_PCTL_RUN(2) | SPC5_ME_PCTL_LP(2))
#define SPC5_CAN_SUB_3_M_CAN_1_STOP_PTCL    (SPC5_ME_PCTL_RUN(0) | SPC5_ME_PCTL_LP(0))
#define SPC5_CAN_SUB_3_M_CAN_1_L0_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_3_M_CAN_1_L1_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_3_M_CAN_1_RAM_START    0UL
#define SPC5_CAN_SUB_3_M_CAN_1_RAM_SIZE     0UL

#define SPC5_USE_CAN_SUB_3_M_CAN_2          FALSE
#define SPC5_CAN_SUB_3_M_CAN_2_START_PTCL   (SPC5_ME_PCTL_RUN(2) | SPC5_ME_PCTL_LP(2))
#define SPC5_CAN_SUB_3_M_CAN_2_STOP_PTCL    (SPC5_ME_PCTL_RUN(0) | SPC5_ME_PCTL_LP(0))
#define SPC5_CAN_SUB_3_M_CAN_2_L0_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_3_M_CAN_2_L1_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_3_M_CAN_2_RAM_START    SPC5_CAN_SUB_3_M_CAN_1_RAM_START + SPC5_CAN_SUB_3_M_CAN_1_RAM_SIZE
#define SPC5_CAN_SUB_3_M_CAN_2_RAM_SIZE     0UL

#define SPC5_USE_CAN_SUB_3_M_CAN_3          FALSE
#define SPC5_CAN_SUB_3_M_CAN_3_START_PTCL   (SPC5_ME_PCTL_RUN(2) | SPC5_ME_PCTL_LP(2))
#define SPC5_CAN_SUB_3_M_CAN_3_STOP_PTCL    (SPC5_ME_PCTL_RUN(0) | SPC5_ME_PCTL_LP(0))
#define SPC5_CAN_SUB_3_M_CAN_3_L0_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_3_M_CAN_3_L1_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_3_M_CAN_3_RAM_START    SPC5_CAN_SUB_3_M_CAN_2_RAM_START + SPC5_CAN_SUB_3_M_CAN_2_RAM_SIZE
#define SPC5_CAN_SUB_3_M_CAN_3_RAM_SIZE     0UL

#define SPC5_USE_CAN_SUB_3_M_CAN_4          FALSE
#define SPC5_CAN_SUB_3_M_CAN_4_START_PTCL   (SPC5_ME_PCTL_RUN(2) | SPC5_ME_PCTL_LP(2))
#define SPC5_CAN_SUB_3_M_CAN_4_STOP_PTCL    (SPC5_ME_PCTL_RUN(0) | SPC5_ME_PCTL_LP(0))
#define SPC5_CAN_SUB_3_M_CAN_4_L0_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_3_M_CAN_4_L1_PRIORITY  INTC_PSR_ENABLE(INTC_PSR_CORE2,10)
#define SPC5_CAN_SUB_3_M_CAN_4_RAM_START    SPC5_CAN_SUB_3_M_CAN_3_RAM_START + SPC5_CAN_SUB_3_M_CAN_3_RAM_SIZE
#define SPC5_CAN_SUB_3_M_CAN_4_RAM_SIZE     0UL

#define SPC5_CAN_SUB_3_RAM_START_PTCL       (SPC5_ME_PCTL_RUN(2) | SPC5_ME_PCTL_LP(2))
#define SPC5_CAN_SUB_3_RAM_STOP_PTCL        (SPC5_ME_PCTL_RUN(0) | SPC5_ME_PCTL_LP(0))

/*
 * CAN SUBSYSTEM driver filter settings.
*/
/* MCAN filter configuration */
#define SPC5_CAN_SUB_MAX_STD_FILTERS        2
#define SPC5_CAN_SUB_MAX_XTD_FILTERS        2
#define SPC5_CAN_MAX_DATA_LENGHT            8U

/* MCAN DEBUG options */
#define CAN_DEBUG_RX_COUNTER                FALSE
#define CAN_DEBUG_TX_COUNTER                FALSE

/*
 * SARADC driver system settings.
 */ 
#define SPC5_SARADC_USE_SARADC12_0          FALSE
#define SPC5_SARADC12_0_PRIORITY            INTC_PSR_ENABLE(INTC_PSR_CORE2, 10)
#define SPC5_SARADC12_0_DMA_CH_ID           1
#define SPC5_SARADC12_0_DMA_IRQ_PRIO        INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10)
#define SPC5_SARADC12_0_DMA_MUX             0U
#define SPC5_SARADC12_0_DMA_DEV_ID          SPC5_SARADC12_0_DMA_MUX0_DEV_ID

#define SPC5_SARADC_USE_SARADC12_1          FALSE
#define SPC5_SARADC12_1_PRIORITY            INTC_PSR_ENABLE(INTC_PSR_CORE2, 10)
#define SPC5_SARADC12_1_DMA_CH_ID           16
#define SPC5_SARADC12_1_DMA_IRQ_PRIO        INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10)
#define SPC5_SARADC12_1_DMA_MUX             1U
#define SPC5_SARADC12_1_DMA_DEV_ID          SPC5_SARADC12_1_DMA_MUX1_DEV_ID

#define SPC5_SARADC_USE_SARADC12_2          FALSE
#define SPC5_SARADC12_2_PRIORITY            INTC_PSR_ENABLE(INTC_PSR_CORE2, 10)
#define SPC5_SARADC12_2_DMA_CH_ID           32
#define SPC5_SARADC12_2_DMA_IRQ_PRIO        INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10)
#define SPC5_SARADC12_2_DMA_MUX             2U
#define SPC5_SARADC12_2_DMA_DEV_ID          SPC5_SARADC12_2_DMA_MUX2_DEV_ID

#define SPC5_SARADC_USE_SARADC12_3          FALSE
#define SPC5_SARADC12_3_PRIORITY            INTC_PSR_ENABLE(INTC_PSR_CORE2, 10)
#define SPC5_SARADC12_3_DMA_CH_ID           48
#define SPC5_SARADC12_3_DMA_IRQ_PRIO        INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10)
#define SPC5_SARADC12_3_DMA_MUX             3U
#define SPC5_SARADC12_3_DMA_DEV_ID          SPC5_SARADC12_3_DMA_MUX3_DEV_ID

#define SPC5_SARADC_USE_SARADC12_SV         FALSE
#define SPC5_SARADC12_SV_PRIORITY           INTC_PSR_ENABLE(INTC_PSR_CORE2, 10)
#define SPC5_SARADC12_SV_DMA_CH_ID          0
#define SPC5_SARADC12_SV_DMA_IRQ_PRIO       INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10)
#define SPC5_SARADC12_SV_DMA_MUX            0U
#define SPC5_SARADC12_SV_DMA_DEV_ID         SPC5_SARADC12_SV_DMA_MUX0_DEV_ID

#define SPC5_SARADC_USE_SARADC10_STANDBY    FALSE
#define SPC5_SARADC10_STANDBY_PRIORITY      INTC_PSR_ENABLE(INTC_PSR_CORE2, 10)
#define SPC5_SARADC10_STANDBY_DMA_CH_ID     16
#define SPC5_SARADC10_STANDBY_DMA_IRQ_PRIO  INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 10)
#define SPC5_SARADC10_STANDBY_DMA_MUX       1U
#define SPC5_SARADC10_STANDBY_DMA_DEV_ID    SPC5_SARADC10_STANDBY_DMA_MUX1_DEV_ID


#define SPC5_SARADC_USE_DMA                 FALSE
#define SPC5_SARADC_DMA_BUFFER_LENGHT       0U
#define SPC5_SARADC_MAX_NUMOFCHANNELS       0U
#define SPC5_SARADC_MAX_NUMOFTHRESHOLDS     1U
#define SPC5_SARADC_DMA_ERROR_HOOK(saradcp) irqSysHalt()

/*
 * SWT driver system settings.
 */

/* SWT0 settings */
#define SPC5_SWT_USE_SWT0                   FALSE
#define SPC5_SWT0_IRQ_PRIORITY              INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 63)

#define SPC5_SWT0_CLOCK_SOURCE_OSC          TRUE
#define SPC5_SWT0_FREQUENCY                 16000000U
#define SPC5_SWT0_TIMEOUT_PERIOD            0
#define SPC5_SWT0_INTERRUPT_MODE            TRUE
#define SPC5_SWT0_PSEUDO_RANDOM_KEY         FALSE
#define SPC5_SWT0_WINDOW_MODE               FALSE
#define SPC5_SWT0_WINDOW_PERIOD             0
#define SPC5_SWT0_STOP_IN_STOP_MODE         FALSE
#define SPC5_SWT0_FREEZE_IN_DEBUG_MODE      TRUE
#define SPC5_SWT0_SYSTEM_RESET              FALSE

/* SWT1 settings */
#define SPC5_SWT_USE_SWT1                   FALSE
#define SPC5_SWT1_IRQ_PRIORITY              INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 63)

#define SPC5_SWT1_CLOCK_SOURCE_OSC          TRUE
#define SPC5_SWT1_FREQUENCY                 16000000U
#define SPC5_SWT1_TIMEOUT_PERIOD            0
#define SPC5_SWT1_INTERRUPT_MODE            TRUE
#define SPC5_SWT1_PSEUDO_RANDOM_KEY         FALSE
#define SPC5_SWT1_WINDOW_MODE               FALSE
#define SPC5_SWT1_WINDOW_PERIOD             0
#define SPC5_SWT1_STOP_IN_STOP_MODE         FALSE
#define SPC5_SWT1_FREEZE_IN_DEBUG_MODE      TRUE
#define SPC5_SWT1_SYSTEM_RESET              FALSE

/* SWT2 settings */
#define SPC5_SWT_USE_SWT2                   FALSE
#define SPC5_SWT2_IRQ_PRIORITY              INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 63)

#define SPC5_SWT2_CLOCK_SOURCE_OSC          TRUE
#define SPC5_SWT2_FREQUENCY                 16000000U
#define SPC5_SWT2_TIMEOUT_PERIOD            0
#define SPC5_SWT2_INTERRUPT_MODE            TRUE
#define SPC5_SWT2_PSEUDO_RANDOM_KEY         FALSE
#define SPC5_SWT2_WINDOW_MODE               FALSE
#define SPC5_SWT2_WINDOW_PERIOD             0
#define SPC5_SWT2_STOP_IN_STOP_MODE         FALSE
#define SPC5_SWT2_FREEZE_IN_DEBUG_MODE      TRUE
#define SPC5_SWT2_SYSTEM_RESET              FALSE

/* SWT3 settings */
#define SPC5_SWT_USE_SWT3                   FALSE
#define SPC5_SWT3_IRQ_PRIORITY              INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 63)

#define SPC5_SWT3_CLOCK_SOURCE_OSC          TRUE
#define SPC5_SWT3_FREQUENCY                 16000000U
#define SPC5_SWT3_TIMEOUT_PERIOD            0
#define SPC5_SWT3_INTERRUPT_MODE            TRUE
#define SPC5_SWT3_PSEUDO_RANDOM_KEY         FALSE
#define SPC5_SWT3_WINDOW_MODE               FALSE
#define SPC5_SWT3_WINDOW_PERIOD             0
#define SPC5_SWT3_STOP_IN_STOP_MODE         FALSE
#define SPC5_SWT3_FREEZE_IN_DEBUG_MODE      TRUE
#define SPC5_SWT3_SYSTEM_RESET              FALSE

/*
 * WKPU driver system settings.
 */
#define SPC5_WKPU_USE_WKPU0                 FALSE
#define SPC5_WKPU_USE_WKPU1                 FALSE

#define SPC5_WKPU0_IRQ0_PRIORITY            INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_WKPU0_IRQ1_PRIORITY            INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_WKPU0_IRQ2_PRIORITY            INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_WKPU0_IRQ3_PRIORITY            INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_WKPU1_IRQ0_PRIORITY            INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_WKPU1_IRQ1_PRIORITY            INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_WKPU1_IRQ2_PRIORITY            INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)
#define SPC5_WKPU1_IRQ3_PRIORITY            INTC_PSR_ENABLE(INTC_PSR_CORE2, 8)

/*
 * eMIOS (PWM/ICU) driver system settings.
 */
#define SPC5_PWM_USE_EMIOS0_CH0             FALSE
#define SPC5_PWM_USE_EMIOS0_CH1             FALSE
#define SPC5_PWM_USE_EMIOS0_CH2             FALSE
#define SPC5_PWM_USE_EMIOS0_CH3             FALSE
#define SPC5_PWM_USE_EMIOS0_CH4             FALSE
#define SPC5_PWM_USE_EMIOS0_CH5             FALSE
#define SPC5_PWM_USE_EMIOS0_CH6             FALSE
#define SPC5_PWM_USE_EMIOS0_CH7             FALSE
#define SPC5_PWM_USE_EMIOS0_GROUP1          FALSE
#define SPC5_PWM_USE_EMIOS0_GROUP2          FALSE
#define SPC5_PWM_USE_EMIOS0_GROUP3          FALSE
#define SPC5_PWM_USE_EMIOS1_GROUP0          FALSE
#define SPC5_PWM_USE_EMIOS1_GROUP1          FALSE
#define SPC5_PWM_USE_EMIOS1_GROUP2          FALSE
#define SPC5_PWM_USE_EMIOS1_GROUP3          FALSE
#define SPC5_PWM_USE_EMIOS2_GROUP0          FALSE
#define SPC5_PWM_USE_EMIOS2_GROUP1          FALSE
#define SPC5_PWM_USE_EMIOS2_GROUP2          FALSE
#define SPC5_PWM_USE_EMIOS2_GROUP3          FALSE


#define SPC5_ICU_USE_EMIOS0_CH0             FALSE
#define SPC5_ICU_USE_EMIOS0_CH1             FALSE
#define SPC5_ICU_USE_EMIOS0_CH2             FALSE
#define SPC5_ICU_USE_EMIOS0_CH3             FALSE
#define SPC5_ICU_USE_EMIOS0_CH4             FALSE
#define SPC5_ICU_USE_EMIOS0_CH5             FALSE
#define SPC5_ICU_USE_EMIOS0_CH6             FALSE
#define SPC5_ICU_USE_EMIOS0_CH7             FALSE

#define SPC5_EMIOS0_GFR_F0F1_PRIORITY       INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS0_GFR_F2F3_PRIORITY       INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS0_GFR_F4F5_PRIORITY       INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS0_GFR_F6F7_PRIORITY       INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS0_GFR_F8F9_PRIORITY       INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS0_GFR_F10F11_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS0_GFR_F12F13_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS0_GFR_F14F15_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS0_GFR_F16F17_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS0_GFR_F18F19_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS0_GFR_F20F21_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS0_GFR_F22F23_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS0_GFR_F24F25_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS0_GFR_F26F27_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS0_GFR_F28F29_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS0_GFR_F30F31_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)

#define SPC5_EMIOS1_GFR_F0F1_PRIORITY       INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS1_GFR_F2F3_PRIORITY       INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS1_GFR_F4F5_PRIORITY       INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS1_GFR_F6F7_PRIORITY       INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS1_GFR_F8F9_PRIORITY       INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS1_GFR_F10F11_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS1_GFR_F12F13_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS1_GFR_F14F15_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS1_GFR_F16F17_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS1_GFR_F18F19_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS1_GFR_F20F21_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS1_GFR_F22F23_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS1_GFR_F24F25_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS1_GFR_F26F27_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS1_GFR_F28F29_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS1_GFR_F30F31_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)

#define SPC5_EMIOS2_GFR_F0F1_PRIORITY       INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS2_GFR_F2F3_PRIORITY       INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS2_GFR_F4F5_PRIORITY       INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS2_GFR_F6F7_PRIORITY       INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS2_GFR_F8F9_PRIORITY       INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS2_GFR_F10F11_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS2_GFR_F12F13_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS2_GFR_F14F15_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS2_GFR_F16F17_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS2_GFR_F18F19_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS2_GFR_F20F21_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS2_GFR_F22F23_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS2_GFR_F24F25_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS2_GFR_F26F27_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS2_GFR_F28F29_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_EMIOS2_GFR_F30F31_PRIORITY     INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)

#define SPC5_EMIOS0_GPRE_VALUE              20UL
#define SPC5_EMIOS0_START_PCTL              (SPC5_ME_PCTL_RUN(2) | SPC5_ME_PCTL_LP(2))
#define SPC5_EMIOS0_STOP_PCTL               (SPC5_ME_PCTL_RUN(0) | SPC5_ME_PCTL_LP(0))

#define SPC5_EMIOS1_GPRE_VALUE              20UL
#define SPC5_EMIOS1_START_PCTL              (SPC5_ME_PCTL_RUN(2) | SPC5_ME_PCTL_LP(2))
#define SPC5_EMIOS1_STOP_PCTL               (SPC5_ME_PCTL_RUN(0) | SPC5_ME_PCTL_LP(0))

#define SPC5_EMIOS2_GPRE_VALUE              20UL
#define SPC5_EMIOS2_START_PCTL              (SPC5_ME_PCTL_RUN(2) | SPC5_ME_PCTL_LP(2))
#define SPC5_EMIOS2_STOP_PCTL               (SPC5_ME_PCTL_RUN(0) | SPC5_ME_PCTL_LP(0))

/*
 * FCCU driver system settings.
 */
#define SPC5_FCCU_CONFIG_IRQ_PRIO           INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SPC5_FCCU_ALARM_IRQ_PRIO            INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)

/*
 * I2C driver system settings.
 */
#define SPC5_I2C_IRQ_PRIORITY               INTC_PSR_ENABLE(INTC_PSR_CORE2, 12)

/*
 * RTC/API driver system settings.
 */
#define SCP5_RTC_RTC_IRQ_PRIORITY           INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)
#define SCP5_RTC_API_IRQ_PRIORITY           INTC_PSR_ENABLE(INTC_PSR_MAINCORE, 8)

/*
 * CRC driver system settings.
 */
#define SPC5_CRC_USE_CRC0                   FALSE
#define SPC5_CRC_USE_CRC1                   FALSE
#define SPC5_CRC_USE_CRC2                   FALSE

#endif /* _LLDCONF_H_ */

/** @} */
