/****************************************************************************
*
* Copyright © 2019-2022 STMicroelectronics - All Rights Reserved
*
* This software is licensed under SLA0098 terms that can be found in the
* DM00779817_1_0.pdf file in the licenses directory of this software product.
* 
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED, 
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
*****************************************************************************/

#ifndef _BOARD_H_
#define _BOARD_H_

#include "pal.h"

/*
 * Setup for a generic SPC58xHxx_cut2 board.
 */

/*
 * Board identifiers.
 */
#define BOARD_SPC58xHXX_EVB
#define BOARD_NAME                  "SPC58xHxx_EVB"

/*
 * Support macros.
 */
#define MSCR_IO_INDEX(port, pin)    (((port) * 16U) + (pin))

/*
 * I/O definitions.
 */
#define PIN_TX                      0U
#define CAN_STB                     2U
#define CAN_EN                      4U
#define PIN_RX                      0U

/*
 * PORT definitions.
 */
#define PORT_PIN_TX                 PORT_C
#define PORT_CAN_STB                PORT_C
#define PORT_CAN_EN                 PORT_C
#define PORT_PIN_RX                 PORT_E

/*
 * MSCR_IO definitions.
 */
#define MSCR_IO_PIN_TX              MSCR_IO_INDEX(PORT_PIN_TX, PIN_TX)
#define MSCR_IO_CAN_STB             MSCR_IO_INDEX(PORT_CAN_STB, CAN_STB)
#define MSCR_IO_CAN_EN              MSCR_IO_INDEX(PORT_CAN_EN, CAN_EN)
#define MSCR_IO_PIN_RX              MSCR_IO_INDEX(PORT_PIN_RX, PIN_RX)

/*
 * MSCR_MUX definitions.
 */
#define MSCR_MUX_PIN_RX             248U

#if !defined(_FROM_ASM_)
#ifdef __cplusplus
extern "C" {
#endif
  void boardInit(void);
#ifdef __cplusplus
}
#endif
#endif /* _FROM_ASM_ */

#endif /* _BOARD_H_ */
