/****************************************************************************
*
* Copyright © 2019 STMicroelectronics - All Rights Reserved
*
* This software is licensed under SLA0098 terms that can be found in the
* DM00779817_1_0.pdf file in the licenses directory of this software product.
* 
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED, 
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
*****************************************************************************/

/*
 * This file is automatically generated and can be overwritten, do no change
 * this file manually.
 */

/*
 * SPC58xHxx_cut2 memory setup.
 */

__irq_stack_size__            = 0;
__process_stack_size__        = 4096;
__core0_irq_stack_size__      = 0;
__core0_process_stack_size__  = 2048;
__core1_irq_stack_size__      = 0;
__core1_process_stack_size__  = 2048;

MEMORY
{
    dataflash : org = 0x00800000, len = 256k
    flash     : org = 0x00FC0000, len = 10M 
    ram       : org = 0x40028000, len = 1376k - 288k
    iram0     : org = 0x50000000, len = 32k
    iram1     : org = 0x51000000, len = 32k
    iram2     : org = 0x52000000, len = 32k
    dram0     : org = 0x50800000, len = 64k
    dram1     : org = 0x51800000, len = 64k
    dram2     : org = 0x52800000, len = 64k
}

ENTRY(_reset_address2)

/*
 * Derived constants.
 */
__flash_size__          = LENGTH(flash);
__flash_start__         = ORIGIN(flash);
__flash_end__           = ORIGIN(flash) + LENGTH(flash);

__ram_size__            = LENGTH(ram);
__ram_start__           = ORIGIN(ram);
__ram_end__             = ORIGIN(ram) + LENGTH(ram);

__iram0_size__          = LENGTH(iram0);
__iram0_start__         = ORIGIN(iram0);
__iram0_end__           = ORIGIN(iram0) + LENGTH(iram0);

__iram1_size__          = LENGTH(iram1);
__iram1_start__         = ORIGIN(iram1);
__iram1_end__           = ORIGIN(iram1) + LENGTH(iram1);

__iram2_size__          = LENGTH(iram2);
__iram2_start__         = ORIGIN(iram2);
__iram2_end__           = ORIGIN(iram2) + LENGTH(iram2);

__dram0_size__          = LENGTH(dram0);
__dram0_start__         = ORIGIN(dram0);
__dram0_end__           = ORIGIN(dram0) + LENGTH(dram0);

__dram1_size__          = LENGTH(dram1);
__dram1_start__         = ORIGIN(dram1);
__dram1_end__           = ORIGIN(dram1) + LENGTH(dram1);

__dram2_size__          = LENGTH(dram2);
__dram2_start__         = ORIGIN(dram2);
__dram2_end__           = ORIGIN(dram2) + LENGTH(dram2);


SECTIONS
{
    . = ORIGIN(flash);
    .boot0 : ALIGN(16) SUBALIGN(16)
    {
        KEEP(*(.boot))
        KEEP(*(.handlers))
        KEEP(*(.crt0))
    } > flash

    .boot1 : ALIGN(16) SUBALIGN(16)
    {
        /* The IVPR registers require a 256 bytes alignment.*/
        . = ALIGN(0x100);
        __ivpr0_base__ = .;
        KEEP(*(.core0_ivors))

        /* The IVPR registers require a 256 bytes alignment.*/
        . = ALIGN(0x100);
        __ivpr1_base__ = .;
        KEEP(*(.core1_ivors))

        /* The IVPR registers require a 256 bytes alignment.*/
        . = ALIGN(0x100);
        __ivpr2_base__ = .;
        KEEP(*(.core2_ivors))

        /* The vectors table requires a 4kB alignment.*/
        . = ALIGN(0x1000);
        KEEP(*(.vectors))
    } > flash

    constructors : ALIGN(4) SUBALIGN(4)
    {
        PROVIDE(__init_array_start = .);
        KEEP(*(SORT(.init_array.*)))
        KEEP(*(.init_array))
        PROVIDE(__init_array_end = .);
    } > flash

    destructors : ALIGN(4) SUBALIGN(4)
    {
        PROVIDE(__fini_array_start = .);
        KEEP(*(.fini_array))
        KEEP(*(SORT(.fini_array.*)))
        PROVIDE(__fini_array_end = .);
    } > flash

    .text_vle : ALIGN(16) SUBALIGN(16)
    {
        *(.text_vle)
        *(.text_vle.*)
        *(.gnu.linkonce.t_vle.*)
    } > flash

    .text : ALIGN(16) SUBALIGN(16)
    {
        *(.text)
        *(.text.*)
        *(.gnu.linkonce.t.*)
    } > flash

    .rodata : ALIGN(16) SUBALIGN(16)
    {
        *(.glue_7t)
        *(.glue_7)
        *(.gcc*)
        *(.rodata)
        *(.rodata.*)
        *(.rodata1)
    } > flash

    .sdata2 : ALIGN(16) SUBALIGN(16)
    {
        __sdata2_start__ = . + 0x8000;
        *(.sdata2)
        *(.sdata2.*)
        *(.gnu.linkonce.s2.*)
        *(.sbss2)
        *(.sbss2.*)
        *(.gnu.linkonce.sb2.*)
    } > flash

    .eh_frame_hdr :
    {
        *(.eh_frame_hdr)
    } > flash

    .eh_frame : ONLY_IF_RO
    {
        *(.eh_frame)
    } > flash

    .romdata : ALIGN(16) SUBALIGN(16)
    {
        __romdata_start__ = .;
    } > flash

    .core0_stacks : ALIGN(16) SUBALIGN(16)
    {
        . = ALIGN(8);
        __core0_irq_stack_base__ = .;
        . += __core0_irq_stack_size__;
        . = ALIGN(8);
        __core0_irq_stack_end__ = .;
        __core0_process_stack_base__ = .;
        __core0_main_thread_stack_base__ = .;
        . += __core0_process_stack_size__;
        . = ALIGN(8);
        __core0_process_stack_end__ = .;
        __core0_main_thread_stack_end__ = .;
    } > dram0

    .core1_stacks : ALIGN(16) SUBALIGN(16)
    {
        . = ALIGN(8);
        __core1_irq_stack_base__ = .;
        . += __core1_irq_stack_size__;
        . = ALIGN(8);
        __core1_irq_stack_end__ = .;
        __core1_process_stack_base__ = .;
        __core1_main_thread_stack_base__ = .;
        . += __core1_process_stack_size__;
        . = ALIGN(8);
        __core1_process_stack_end__ = .;
        __core1_main_thread_stack_end__ = .;
    } > dram1

    .core2_stacks : ALIGN(16) SUBALIGN(16)
    {
        . = ALIGN(8);
        __irq_stack_base__ = .;
        . += __irq_stack_size__;
        . = ALIGN(8);
        __irq_stack_end__ = .;
        __process_stack_base__ = .;
        __main_thread_stack_base__ = .;
        . += __process_stack_size__;
        . = ALIGN(8);
        __process_stack_end__ = .;
        __main_thread_stack_end__ = .;
    } > dram2

    .data : AT(__romdata_start__)
    {
        . = ALIGN(4);
        __data_start__ = .;
        *(.data)
        *(.data.*)
        *(.gnu.linkonce.d.*)
    } > ram

    .sdata :
    {
        . = ALIGN(4);
        __sdata_start__ = . + 0x8000;
        *(.sdata)
        *(.sdata.*)
        *(.gnu.linkonce.s.*)
        __data_end__ = .;
    } > ram

    .sbss :
    {
        __bss_start__ = .;
        *(.sbss)
        *(.sbss.*)
        *(.gnu.linkonce.sb.*)
        *(.scommon)
    } > ram

    .bss :
    {
        *(.bss)
        *(.bss.*)
        *(.gnu.linkonce.b.*)
        *(COMMON)
        __bss_end__ = .;
    } > ram

    __heap_base__   = __bss_end__;
    __heap_end__    = __ram_end__;
}
